export function formatDate(dateString) {
  // Si no hay valor, regresar directamente lo que venga
  if (!dateString || typeof dateString !== "string") {
    return dateString ?? "No definida";
  }

  // Intentar convertir a Date
  const date = new Date(dateString.replace(" ", "T"));

  // Si no es válida, devolver lo original
  if (isNaN(date.getTime())) {
    return dateString;
  }

  // Devolver formateado
  return date.toLocaleDateString("es-MX", {
    year: "numeric",
    month: "long",
    day: "numeric"
  });
}

export function formatDateForInput(dateString) {
  if (!dateString || typeof dateString !== "string") {
    return "";
  }

  const date = new Date(dateString.replace(" ", "T"));

  if (isNaN(date.getTime())) {
    return "";
  }

  // Generar YYYY-MM-DD
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, "0");
  const day = String(date.getDate()).padStart(2, "0");

  return `${year}-${month}-${day}`;
}