import Modal from "../../../../components/modal/modal.js";

// Modal para crear una nueva URL protegida
export const modalCreateProtectedUrl = new Modal({
    title : "Compartir proyecto",
    subtitle: "Genera un enlace protegido para compartir el proyecto con otros usuarios.",
    content : ({url}) => `
        <div class="pt-2 rounded-md">
            <div class="flex flex-col gap-2">
                <div class="flex border border-zinc-200 rounded-md overflow-hidden flex-grow items-center p-1">
                    <input type="text" id="protectedUrlInput" value="${url ?? ''}" disabled class="text-zinc-700 w-full px-2 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" readonly placeholder="Genera un enlace protegido" />
                    <button id="copyProtectedUrlBtn" class="flex gap-2 items-center bg-zinc-100 border border-zinc-200 text-zinc-700 p-2 text-nowrap rounded-md hover:bg-zinc-200 hover:scale-102 transition-all ease-in-out cursor-pointer">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 0 1-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 0 1 1.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 0 0-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 0 1-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H9.75" />
                        </svg>
                    </button>  
                </div>
                <button id="generateProtectedUrlBtn" class="flex justify-center items-center gap-2 bg-zinc-800 text-white p-2 text-nowrap rounded-md hover:bg-zinc-950 hover:scale-102 transition-all ease-in-out cursor-pointer">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
                    </svg>
                    <span>Generar token</span>
                </button> 
            </div>
        </div>`
}); 
