import Modal from "../../../../components/modal/modal.js";

// Modal para crear un nuevo proyecto
export const modalCreateProject = new Modal({
    title : "Crear nuevo proyecto",
    subtitle: "LLena la información necesaria para crear un nuevo proyecto.",
    content : ({clients = []}) => `
        <div id="projectCreateForm" class="pt-2 rounded-md">
            <div class="flex flex-col gap-2">
                <div class="flex flex-col items-start w-full gap-1">
                    <div class="flex justify-between items-center w-full">
                        <label class="text-zinc-500 text-sm">Cliente</label>
                    </div>
                     <select id="client_id" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out">
                        <option value="">--</option>   
                        ${clients?.map(c => {
                            if(c?.isActive) return `<option value="${c?.id}">${c?.name_company} : ${c?.name_contact}</option>`;
                        }).join("")}
                    </select>
                </div>
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Nombre del proyecto</label>
                    <input id="name" placeholder="Mobil Construcciones" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                </div>
                <div class="flex gap-2 xs:flex-col sm:flex-row justify-between items-center">
                    <div class="flex flex-col items-start w-full gap-1">
                        <label class="text-zinc-500 text-sm">Fecha de inicio</label>
                        <input id="start_date" type="date" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                    </div>
                    <div class="flex flex-col items-start w-full gap-1">
                        <label class="text-zinc-500 text-sm">Fecha de termino</label>
                        <input id="end_date" type="date" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                    </div>
                </div>
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Prioridad</label>
                    <select id="priority" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out">
                        <option value="baja">Baja</option>
                        <option value="media">Media</option>
                        <option value="alta">Alta</option>
                    </select>
                </div>
            </div>
            <div class="flex sm:flex-row xs:flex-col sm:items-center sm:justify-between sm:mt-4 xs:mt-6 gap-4">
                <div class="flex items-start sm:gap-2 xs:gap-4">
                    <input checked type="checkbox" id="isConfigured" class="accent-[#393784] mt-1"/>
                    <label class="text-zinc-500 text-xs">Selecciona si deseas el proyecto base ya configurado. <button class="text-[#393784] text-xs hover:underline cursor-pointer" id="helpConfigurationBtn">¿Qué es esto?</button></label>
                </div>
                <button id="SubmitProject" class="text-white font-medium p-2 rounded-lg bg-zinc-900 cursor-pointer flex gap-2 items-center hover:scale-105 transition-all ease-in-out">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd" d="M6 3a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h12a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm1.5 1.5a.75.75 0 0 0-.75.75V16.5a.75.75 0 0 0 1.085.67L12 15.089l4.165 2.083a.75.75 0 0 0 1.085-.671V5.25a.75.75 0 0 0-.75-.75h-9Z" clip-rule="evenodd" />
                    </svg>
                    <span class="text-sm text-nowrap">Crear proyecto</span>
                </button>
            </div>
        </div>`
}); 
