import ModalBar from "../../../../components/modal/modalBar.js";

// Modal para crear un nuevo proyecto
export const modalListMembers = new ModalBar({
     title: "Listado de miembros",
     subtitle: "Esto es un ejemplo de drawer",
     side: "right",  
     content: ({users = [], restUsers = []}) => `
          <div class="flex flex-col gap-2">
               <!-- Sección: Agregar nuevo integrante -->
               <div class="flex flex-col border border-zinc-200 rounded-lg p-4">
                    <h3 class="text-zinc-600 text-sm mb-2">Agregar nuevo integrante</h3>
                    
                    <input type="text" id="searchUser" placeholder="Buscar usuario..." class="p-2 border border-zinc-300 rounded-md w-full mb-3" />

                    <div id="userSearchResults" class="flex flex-col gap-2 max-h-60 overflow-y-auto">
                         ${restUsers?.length > 0 ? restUsers.map(user => {
                              if(user?.isActive) return `
                                   <div class="flex justify-between items-center p-2 bg-zinc-50 rounded-md hover:bg-gray-50 add-user-item" data-user-id="${user?.id}">
                                        <div class="flex flex-col">
                                             <span>${user?.name}</span>
                                             <span class="text-xs text-[#393784] font-medium">${user?.role?.name}</span>
                                        </div>
                                        <button class="text-[#393784] hover:bg-[#eeedfa] p-1 cursor-pointer rounded-full transition-all ease-in-out add-user-btn">
                                             <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                                  <path stroke-linecap="round" stroke-linejoin="round" d="M18 7.5v3m0 0v3m0-3h3m-3 0h-3m-2.25-4.125a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0ZM3 19.235v-.11a6.375 6.375 0 0 1 12.75 0v.109A12.318 12.318 0 0 1 9.374 21c-2.331 0-4.512-.645-6.374-1.766Z" />
                                             </svg>
                                        </button>
                                   </div>
                                   `
                         }).join("") : `<div class="text-zinc-500 text-sm rounded-lg bg-zinc-50 p-5 text-center">No hay usuarios disponibles para agregar.</div>`}
                    </div>
               </div>

               <div class="p-4 rounded-lg bg-zinc-50 flex flex-col gap-4">
                    <h3 class="text-zinc-600 text-sm">Integrantes del proyecto</h3>
                    ${
                         users?.length > 0 ? (`
                              <div class="flex flex-col divide-y divide-gray-200 shadow rounded-lg overflow-hidden gap-1 p-2">
                                   ${users?.map((user, index) => {
                                        if(user?.isActive == true) {
                                             return `
                                                  <div class="flex items-center justify-between p-3 bg-white transition rounded-md">
                                                       <div class="flex items-center gap-2">
                                                            <span class="text-zinc-600 font-medium border-r pr-4 border-r-zinc-200">${index + 1}</span>
                                                            <div class="pl-2 flex flex-col">
                                                                 <span class="font-medium text-zinc-800">${user?.name}</span>
                                                                 <span class="font-medium text-[#393784] text-xs">${user?.role?.name}</span>
                                                            </div>
                                                       </div>
                                                       <button class="text-sm text-red-600 hover:bg-red-100 transition-all ease-in-out p-1 rounded-full cursor-pointer remove-user-btn" data-user-id="${user.id}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                                                 <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                                                            </svg>
                                                       </button>
                                                  </div>
                                             `
                                        } else {
                                             return `
                                                  <div class="flex items-center justify-between p-3 bg-zinc-100 transition rounded-md">
                                                       <div class="flex items-center gap-2">
                                                            <span class="text-zinc-400 font-medium border-r pr-4 border-r-zinc-200">${index + 1}</span>
                                                            <div class="pl-2 flex flex-col">
                                                                 <span class="font-medium text-zinc-400">${user?.name}</span>
                                                                 <span class="font-medium text-[#393784]/50 text-xs">${user?.role?.name}</span>
                                                            </div>
                                                       </div>
                                                  </div>
                                             `
                                        }
                                   }).join("")}
                                   <span class="text-zinc-500 text-[10px]">Solo los integrantes de esta lista tienen acceso al proyecto.</span>
                              </div>
                         `) : (`
                              <div class="flex justify-center items-center p-5 border border-dashed border-zinc-300 rounded-md">
                                   <span class="p-2 text-sm text-zinc-500">No se han definido integrantes.</span> 
                              </div>
                         `)
                    }
               </div>
          </div>
     `, 
});
