import { formatDate } from "../../../utils/formatter.js";
import { extensionIcons } from "../../../utils/icons.js";

export default function renderStageDetails(stage) {
    let stageStatusColors = "";

    switch (stage?.status_traffic_light) {
        case "rojo":
            stageStatusColors = "bg-red-500";
            break;
        case "amarillo":
            stageStatusColors = "bg-yellow-500";
            break; 
        case "verde":
            stageStatusColors = "bg-green-500";
            break
        default:
            stageStatusColors = "bg-gray-500";
            break;
    }

    const container = document.getElementById("stage-details");

    const documentsHTML = (stage.documents || [])
        .map(doc => {
            // Obtener extensión del archivo
            const extension = doc?.file_name?.split('.').pop()?.toLowerCase() || 'desconocido';
            // Asignar colores por tipo de archivo
            const iconSVG = extensionIcons[extension] || extensionIcons['unknown'];

            return `
                <div class="border border-zinc-200 rounded-lg shadow-sm hover:shadow-lg transition-all duration-200 w-full flex flex-col sm:flex-row justify-between items-start p-4 gap-4 bg-white">
                
                    <!-- Icono de archivo -->
                    <div class="flex items-center gap-3 flex-shrink-0">
                        ${iconSVG}
                    </div>

                    <!-- Información principal -->
                    <div class="flex flex-col flex-grow gap-1 overflow-hidden">
                        <h3 class="font-semibold text-zinc-800 truncate">${doc?.name_document}</h3>
                        <span class="text-xs text-zinc-500">${formatDate(doc?.created_at)}</span>
                        <p class="text-xs text-zinc-500 truncate">Subido por: <span class="text-blue-500">@${doc.user?.username || "Desconocido"}</span></p>
                        <p class="text-xs text-zinc-400 truncate">${doc?.description_document || "Sin descripción"}</p>
                    </div>

                <!-- Botones de acción -->
                    <div class="flex gap-2 items-center flex-shrink-0 mt-2 sm:mt-0">
                        <button class="w-full justify-between flex items-center gap-1 bg-blue-100 text-blue-600 hover:bg-blue-200 px-3 py-1 rounded-md text-sm transition-all duration-200" data-doc-id="${doc?.id}" data-action="download">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 8.25H7.5a2.25 2.25 0 0 0-2.25 2.25v9a2.25 2.25 0 0 0 2.25 2.25h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25H15M9 12l3 3m0 0 3-3m-3 3V2.25"/>
                            </svg>
                        </button>
                        <button class="w-full justify-between flex items-center gap-1 bg-zinc-100 text-zinc-300 hover:bg-zinc-200 px-3 py-1 rounded-md text-sm transition-all duration-200" data-doc-id="${doc?.id}" data-action="edit">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                            </svg>
                        </button>
                        <button class="w-full justify-between flex items-center gap-1 bg-red-100 text-red-600 hover:bg-red-200 px-3 py-1 rounded-md text-sm transition-all duration-200" data-doc-id="${doc?.id}" data-action="delete">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"/>
                            </svg>
                        </button>
                    </div>
                </div>
            `;
        }).join("");

    container.innerHTML = `
        <div class="flex flex-col w-full h-full gap-4 sticky top-2">
            <div class="flex flex-col justify-between gap-2">
                <div class="flex justify-between items-center">
                    <h3 class="text-2xl font-bold">${stage?.name}</h3>
                    <div class="flex gap-2 items-center">
                        <button id="modal_editStage" class="text-zinc-800 p-1 rounded-md hover:bg-zinc-200 hover:scale-102 transition-all ease-in-out cursor-pointer">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                                <path d="M18.75 12.75h1.5a.75.75 0 0 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5ZM12 6a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 12 6ZM12 18a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 12 18ZM3.75 6.75h1.5a.75.75 0 1 0 0-1.5h-1.5a.75.75 0 0 0 0 1.5ZM5.25 18.75h-1.5a.75.75 0 0 1 0-1.5h1.5a.75.75 0 0 1 0 1.5ZM3 12a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5A.75.75 0 0 1 3 12ZM9 3.75a2.25 2.25 0 1 0 0 4.5 2.25 2.25 0 0 0 0-4.5ZM12.75 12a2.25 2.25 0 1 1 4.5 0 2.25 2.25 0 0 1-4.5 0ZM9 15.75a2.25 2.25 0 1 0 0 4.5 2.25 2.25 0 0 0 0-4.5Z" />
                            </svg>
                        </button>
                        <span class="p-2 ${stageStatusColors} rounded-full border border-zinc-300"></span>
                    </div>
                </div>
                <div class="flex xs:flex-col sm:flex-row sm:justify-between sm:items-center xs:items-start">
                    <span class="text-zinc-600 text-sm">${stage?.description || "--"}</span>
                    <span class="text-zinc-600 text-sm">${formatDate(stage?.start_date?.date) ?? ""} - ${formatDate(stage?.end_date?.date) ?? ""}</span>
                </div>
            </div>
            <div class="flex flex-col gap-2">
                <div class="flex justify-between items-center gap-4">
                    <h3 class="text-sm text-zinc-600 font-medium">Listado de documentos asociados</h3>
                    <button id="btnOpenUploadModal" data-stage-id="${stage?.id}" data-stage-name="${stage?.name}" class="flex items-center gap-1  p-2 text-[#393784] rounded-lg bg-[#eeedfa] transition-all text-sm hover:cursor-pointer hover:bg-[#e6e4fc] hover:scale-105">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                            <path d="M9.97.97a.75.75 0 0 1 1.06 0l3 3a.75.75 0 0 1-1.06 1.06l-1.72-1.72v3.44h-1.5V3.31L8.03 5.03a.75.75 0 0 1-1.06-1.06l3-3ZM9.75 6.75v6a.75.75 0 0 0 1.5 0v-6h3a3 3 0 0 1 3 3v7.5a3 3 0 0 1-3 3h-7.5a3 3 0 0 1-3-3v-7.5a3 3 0 0 1 3-3h3Z" />
                            <path d="M7.151 21.75a2.999 2.999 0 0 0 2.599 1.5h7.5a3 3 0 0 0 3-3v-7.5c0-1.11-.603-2.08-1.5-2.599v7.099a4.5 4.5 0 0 1-4.5 4.5H7.151Z" />
                        </svg>
                        <span class="xs:hidden sm:block">Subir documento</span>
                    </button>
                </div>
                <div class="flex flex-col gap-2" id="containerDocuments">
                    ${documentsHTML.length > 0 ? documentsHTML : '<div class="text-center py-8 text-zinc-500 text-sm border border-dashed border-zinc-300 rounded-lg bg-zinc-50">No hay documentos cargados en esta etapa</div>'}
                </div>
            </div>
            <div class="flex justify-between items-center border-t border-zinc-300 pt-4">
                <button id="btn_deleteStage" data-stage-id="${stage?.id}" class="bg-white p-2 rounded-lg shadow cursor-pointer hover:scale-105 transition-all ease-in-out">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5 text-red-500">
                        <path fill-rule="evenodd" d="M16.5 4.478v.227a48.816 48.816 0 0 1 3.878.512.75.75 0 1 1-.256 1.478l-.209-.035-1.005 13.07a3 3 0 0 1-2.991 2.77H8.084a3 3 0 0 1-2.991-2.77L4.087 6.66l-.209.035a.75.75 0 0 1-.256-1.478A48.567 48.567 0 0 1 7.5 4.705v-.227c0-1.564 1.213-2.9 2.816-2.951a52.662 52.662 0 0 1 3.369 0c1.603.051 2.815 1.387 2.815 2.951Zm-6.136-1.452a51.196 51.196 0 0 1 3.273 0C14.39 3.05 15 3.684 15 4.478v.113a49.488 49.488 0 0 0-6 0v-.113c0-.794.609-1.428 1.364-1.452Zm-.355 5.945a.75.75 0 1 0-1.5.058l.347 9a.75.75 0 1 0 1.499-.058l-.346-9Zm5.48.058a.75.75 0 1 0-1.498-.058l-.347 9a.75.75 0 0 0 1.5.058l.345-9Z" clip-rule="evenodd" />
                    </svg>
                </button>
                <button id="btn_updateTrafficLight" data-stage-id="${stage?.id}" class="flex gap-2 items-center p-2 rounded-lg px-4 bg-zinc-900 text-white font-medium hover:scale-102 cursor-pointer transition-all ease-in-out">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd" d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z" clip-rule="evenodd" />
                    </svg>
                    <span>Completar</span>
                </button>
            </div>
        </div>
    `;
}