import { modalCreateProject } from "./components/modals/ModalAddEdit.js"; 
import { createProject } from "../../hooks/projects/createProject.js";
import { modalHelp_baseConfiguration } from "./components/modals/help/ModalBaseConfiguration.js";
import { getAllClients } from "../../hooks/clients/getClients.js";

const modal_createProject = document.getElementById('modal_createProject'); // Botón para abrir modal para crear proyecto

// Apertura del modal para la creación de un nuevo proyecto
if(modal_createProject){
    modal_createProject.addEventListener('click', async () => {
        const dataOptions = await getAllClients();
        // Se abre el modal
        modalCreateProject.open({
            clients: dataOptions?.data || []
        });
        
        // Se añade un evento submit para cuando envié la info
        document.getElementById('SubmitProject').addEventListener('click', async () => {
            document.getElementById('SubmitProject').disabled = true; // Deshabilita el botón para evitar múltiples envíos
            const response = await createProject();
            // Llamada a la función para crear el proyecto
            if(!response) return;
            // Si se creó correctamente, se cierra el modal
            modalCreateProject.close();
            // Recarga de la página para ver el nuevo proyecto
            window.location.reload(); 
            // aquí se puede mejorar para no recargar la pagina
        });

        // Se añade un evento para mostrar el modal del helper de configuración
        document.getElementById("helpConfigurationBtn").addEventListener("click", () => {
            modalHelp_baseConfiguration.open({ message: "Hola desde el drawer!" });
        });
    });
}