import Modal from "../../../../components/modal/modal.js";

// Modal para actualizar un cliente
export const modalEditClient = new Modal({
    title : "Actualizar un cliente",
    subtitle: "LLena la información necesaria para actualizar un cliente.",
    content : ({client}) => `
        <div id="clientCreateForm" class="pt-2 rounded-md">
            <div class="flex flex-col gap-2">
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Nombre de la empresa</label>
                    <input id="name_company" value="${client.name_company}" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                </div>
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Nombre del contacto</label>
                    <input id="name_contact" value="${client.name_contact}" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                </div>  
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Numero de contacto</label>
                    <input id="phone_contact" value="${client.phone_contact}" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                </div> 
                <div class="flex flex-col items-start w-full gap-1">
                    <label class="text-zinc-500 text-sm">Email de contacto</label>
                    <input id="email_contact" value="${client.email_contact}" class="text-zinc-700 p-2 border border-zinc-200 rounded-lg bg-zinc-50 w-full outline-none focus:bg-zinc-100 transition-all ease-in-out"/>
                </div>        
            </div>
            <div class="flex sm:flex-row xs:flex-col sm:items-center sm:justify-between sm:mt-4 xs:mt-6 gap-4">
                <span></span>
                <button id="addClientBtn" class="text-white font-medium p-2 rounded-lg bg-zinc-900 cursor-pointer flex gap-2 items-center hover:scale-105 transition-all ease-in-out">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd" d="M6 3a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h12a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm1.5 1.5a.75.75 0 0 0-.75.75V16.5a.75.75 0 0 0 1.085.67L12 15.089l4.165 2.083a.75.75 0 0 0 1.085-.671V5.25a.75.75 0 0 0-.75-.75h-9Z" clip-rule="evenodd" />
                    </svg>
                    <span class="text-sm text-nowrap">Actualizar cliente</span>
                </button>
            </div>
        </div>`
}); 
