import { getAllRoles } from "../hooks/roles/getAllRoles.js";
import { addUser } from "../hooks/users/addUser.js";
import { desactivateUser } from "../hooks/users/desactivateUser.js";
import { modalCreateClient } from "../pages/users/components/modals/ModalAdd.js";
import { modalEditUser } from "../pages/users/components/modals/ModalEdit.js";

export default class User {
    constructor(){
        this.roles = [];
    }

    async add(){
        modalCreateClient.onOpen = () => {
            document.getElementById('addUserBtn')?.addEventListener('click', async (e) => {
                const response = await addUser();
                if(!response) return alert(`Error al crear el usuario: ${response?.message || 'Error desconocido'}`);

                alert("Usuario creado exitosamente.");
                modalCreateClient.close();
                location.reload();
            });
        };

        if(this.roles.length === 0){
            const rolesResponse = await getAllRoles();
            this.roles = rolesResponse?.data || [];
        }

        modalCreateClient.open({roles: this.roles});
    }

    async edit(user){
        modalEditUser.onOpen = () => {
            document.getElementById('editUserBtn')?.addEventListener('click', async (e) => {
                const response = await addUser(user.id);
                if(!response) return alert(`Error al actualizar el usuario: ${response?.message || 'Error desconocido'}`);

                alert("Usuario actualizado exitosamente.");
                modalEditUser.close();
                location.reload();
            });
        };

        if(this.roles.length === 0){
            const rolesResponse = await getAllRoles();
            this.roles = rolesResponse?.data || [];
        }

        modalEditUser.open({user, roles: this.roles});
    }

    async desactivate(userId){
        if(!confirm('Al desactivar este usuario, este perdera acceso al sistema.')) return;
        const response = await desactivateUser(userId);
        if(!response) return alert(`Error al actualizar el estado de el usuario: ${response?.message || 'Error desconocido'}`);

        alert("Actualización de estado exitosa  .");
        location.reload();
    }
}