import { addClient } from "../hooks/clients/addClient.js";
import { desactivateClient } from "../hooks/clients/desactivateClient.js";
import { modalCreateClient } from "../pages/clients/components/modals/ModalAdd.js";
import { modalEditClient } from "../pages/clients/components/modals/ModalEdit.js";

export default class Client {
    async add(){
        modalCreateClient.onOpen = () => {
            document.getElementById('addClientBtn')?.addEventListener('click', async (e) => {
                const response = await addClient();
                if(response){
                    modalCreateClient.close();
                    window.location.reload();
                }
            });
        };

        modalCreateClient.open();
    }

    async edit(client){
        modalEditClient.onOpen = () => {
            document.getElementById('addClientBtn')?.addEventListener('click', async (e) => {
                const response = await addClient(client.id);
                if(response){
                    modalEditClient.close();
                    window.location.reload();
                }
            });
        };
        modalEditClient.open({ client });
    }

    async desactivate(clientId){
        if(!confirm('Al desactivar este cliente, no se le podra generar nuevos proyectos.')) return;
        const response = await desactivateClient(clientId);
        if(response){
            window.location.reload();
        }
    }
}