import { useStageApi } from '../../api/stageApi.js';

const { putStage, putTrafficLight } = useStageApi();

export const updateStage = async (stageId) => {
    const name = document.getElementById('name');
    const description = document.getElementById('description');
    const start_date = document.getElementById('start_date');
    const end_date = document.getElementById('end_date');

    const stageData = {
        id: stageId,
        name: name.value,
        description: description.value,
        start_date: start_date.value,
        end_date: end_date.value,
    };

    const emptyFields = Object.entries(stageData).filter(([key, value]) => value === "");

    if (emptyFields.length > 0) {
        alert(`Por favor asegúrate de llenar todos los campos.`);
        return false; // detener ejecución
    }

    const response = await putStage(stageId, stageData);

    if (response?.success) return true;
    
    alert(`No se pudo crear la etapa correspondiente, ${response?.message}`);
    return false;
}

export const updateTrafficLight = async (stageId, status_traffic_light) => {
    const response = await putTrafficLight(stageId, status_traffic_light);

    if (response?.success) return true;

    alert(`No se pudo actualizar el semáforo de la etapa, ${response?.message}`);
    return false;
}
