import { useStageApi } from '../../api/stageApi.js';

const { postStage } = useStageApi();

export const createStage = async (parentId, project_id) => {
    const name = document.getElementById('name');
    const description = document.getElementById('description');
    const start_date = document.getElementById('start_date');
    const end_date = document.getElementById('end_date');

    const stageData = {
        name: name.value,
        description: description.value,
        start_date: start_date.value,
        end_date: end_date.value,
        parent_id: parentId,
        project_id:  project_id,
        status: 'cerrado'
    };

    const emptyFields = Object.entries(stageData).filter(([key, value]) => value === "");

    if (emptyFields.length > 0) {
        alert(`Por favor asegúrate de llenar todos los campos.`);
        return false; // detener ejecución
    }

    const response = await postStage(stageData);

    if (response?.success) return response.data;
    
    alert(`No se pudo crear la etapa correspondiente, ${response?.message}`);
    return null;
}