import { useProjectApi } from '../../api/projectApi.js';

const { postProject, getProjects } = useProjectApi();

export const createProject = async () => {
    const client_id = document.getElementById('client_id');
    const name = document.getElementById('name');
    const start_date = document.getElementById('start_date');
    const end_date = document.getElementById('end_date');
    const priority = document.getElementById('priority');
    const isConfigured = document.getElementById('isConfigured'); 

    const projectData = {
        client_id: client_id.value,
        name: name.value,
        start_date: start_date.value,
        end_date: end_date.value,
        priority: priority.value,
        isConfigured: isConfigured.checked
    };

    const emptyFields = Object.entries(projectData).filter(([key, value]) => value === "");

    if (emptyFields.length > 0) {
        alert(`Por favor asegúrate de llenar todos los campos.`);
        return false; // detener ejecución
    }

    const response = await postProject(projectData);

    if (response?.success) return true;

    alert(`No se pudo crear el proyecto, ${response?.message}`);
    return false;
}
    