import { useClientApi } from "../../api/clientApi.js";

const { postClient, putClient } = useClientApi();

export const addClient = async (clientId = null) => {
    const name_contact = document.getElementById('name_contact');
    const name_company = document.getElementById('name_company');
    const phone_contact = document.getElementById('phone_contact');
    const email_contact = document.getElementById('email_contact');

    const clientData = {
        'name_contact' : name_contact.value,
        'name_company' : name_company.value,
        'phone_contact': phone_contact.value,
        'email_contact': email_contact.value
    }

    const emptyFields = Object.entries(clientData).filter(([key, value]) => value === "");
    
    if (emptyFields.length > 0) {
        alert(`Por favor asegúrate de llenar todos los campos.`);
        return;
    }

    if(clientId) return await putClient({ id: clientId, ...clientData });
    else return await postClient(clientData);
}