import apiClient from "../api/apiClient.js";

export const useUserApi = () => {
    const { fetchData } = apiClient();

    const getUsers = async () => {
        const response = await fetchData('/users', 'GET');
        return response;
    }

    const postUser = async (userData) => {
        const response = await fetchData("/users", "POST", userData);
        return response;
    };

    const putUser = async (userData) => {
        const response = await fetchData(`/users/${userData.id}`, "PUT", userData);
        return response;
    };

    const deleteUser = async (userId) => {
        const response = await fetchData(`/users/${userId}`, "DELETE");
        return response;
    }

    return {
        getUsers, // Obtiene todos los usuarios del servidor
        postUser, // Sube un usuario al servidor
        putUser, // Actualiza un usuario en el servidor
        deleteUser // Elimina un usuario del servidor
    }
}