import apiClient from "../api/apiClient.js";

export const useStageApi = () => {
    const { fetchData } = apiClient();

    const postStage = async (stageData) => {
        const response = await fetchData("/stages", "POST", stageData);
        return response;
    };

    const getStageById = async (id) => {
        const response = await fetchData(`/stage/${id}`, 'GET');
        return response;
    };

    const putStage = async (id, stageData) => {
        const response = await fetchData(`/stage/${id}`, 'PUT', stageData);
        return response;
    };

    const deleteStage = async (id) => {
        const response = await fetchData(`/stage/${id}`, 'DELETE');
        return response;
    };

    const putTrafficLight = async (stageId, status_traffic_light) => {
        const response = await fetchData(`/stage/${stageId}/traffic-light`, 'PUT', { status_traffic_light });
        return response;
    };

    return {
        postStage, // Crea una nueva etapa
        getStageById, //Obtiene la información de una etapa
        putStage, // Actualiza una etapa
        deleteStage, // Elimina una etapa
        putTrafficLight, // Actualiza el semáforo de una etapa
    }
}