import apiClient from "../api/apiClient.js";

export const useRoleApi = () => {
    const { fetchData } = apiClient();

    const getRoles = async () => {
        const response = await fetchData('/roles', 'GET');
        return response;
    }

    const postRole = async (roleData) => {
        const response = await fetchData("/roles", "POST", roleData);
        return response;
    };

    const putRole = async (roleData) => {
        const response = await fetchData(`/roles/${roleData.id}`, "PUT", roleData);
        return response;
    };

    const deleteRole = async (roleId) => {
        const response = await fetchData(`/roles/${roleId}`, "DELETE");
        return response;
    }

    return {
        getRoles, // Obtiene todos los roles del servidor
        postRole, // Sube un rol al servidor
        putRole, // Actualiza un rol en el servidor
        deleteRole // Elimina un rol del servidor
    }
}