import apiClient from "../api/apiClient.js";

export const useProjectApi = () => {
    const { fetchData } = apiClient();

    const postProject = async (projectData) => {
        const response = await fetchData("/projects", "POST", projectData);
        return response;
    };

    const getAllProjectUsers = async (projectId) => {
        const response = await fetchData(`/projects/${projectId}/users`, "GET");
        return response;
    }

    const postProjectUser = async (userProject) => {
        const response = await fetchData(`/projects/users`, 'POST', userProject);
        return response;
    }

    const deleteProjectUser = async (projectId, userId) => {
        const response = await fetchData(`/projects/${projectId}/users/${userId}`, 'DELETE');
        return response;
    }

    const postProtectUrl = async (resource_id) => {
        const response = await fetchData(`/project/shared`, 'POST', { resource_id });
        return response;
    }

    const getProtectUrl = async (projectId) => {
        const response = await fetchData(`/project/shared/${projectId}`, 'GET');
        return response;
    }

    return { 
        postProject, // Envía la información necesaria para crear un nuevo proyecto
        getAllProjectUsers, // Obtiene la lista de integrantes de un proyecto
        deleteProjectUser, // Remueve a un usuario de un proyecto
        postProjectUser, // Añade a un usuario como integrante a un proyecto
        postProtectUrl, // Crea una URL protegida para un proyecto
        getProtectUrl, // Obtiene la URL protegida de un proyecto
    };
};
