import apiClient from "../api/apiClient.js";

export const useDocumentApi = () => {
    const { fetchData } = apiClient();

    const postDocument = async (documentData) => {
        const response = await fetchData("/evidence", "POST", documentData, {}, true);
        return response;
    };

    const deleteDocument = async (documentId) => {
        const response = await fetchData(`/evidence/${documentId}`, "DELETE");
        return response;
    };

    return {
        postDocument, // Sube un archivo a el servidor
        deleteDocument, // Elimina un archivo del servidor
    }
}