import apiClient from "../api/apiClient.js";

export const useClientApi = () => {
    const { fetchData } = apiClient();

    const getClients = async () => {
        const response = await fetchData('/clients', 'GET');
        return response;
    }

    const postClient = async (clientData) => {
        const response = await fetchData("/clients", "POST", clientData);
        return response;
    };

    const putClient = async (clientData) => {
        const response = await fetchData(`/clients/${clientData.id}`, "PUT", clientData);
        console.log(response);
        return response;
    };

    const deleteClient = async (clientId) => {
        const response = await fetchData(`/clients/${clientId}`, "DELETE");
        return response;
    }

    return {
        getClients, // Obtiene todos los clientes del servidor
        postClient, // Sube un cliente al servidor
        putClient, // Actualiza un cliente en el servidor
        deleteClient // Elimina un cliente del servidor 
    }
}