<?php include_once __DIR__.'/../includes/Header.php'; ?>
        <main class="flex lg:flex-row xs:flex-col h-screen overflow-hidden w-screen bg-slate-50">
        <?php include_once __DIR__.'/../includes/Aside.php'; ?>
        <div class="px-5 xs:pt-0 lg:pt-5 w-full overflow-y-scroll pb-2">
            <section class="flex flex-col p-5 w-full gap-6 bg-white shadow rounded-lg h-fit">
                <article class="flex items-center justify-between">
                    <div class="flex flex-col gap-1">
                        <span class="text-zinc-500 text-sm font-medium">Control de cuentas</span>
                        <h1 class="text-zinc-800 font-bold md:text-3xl xs:text-2xl">Gestión de usuarios</h1>
                    </div>
                    <nav class="flex gap-2 items-center">
                        <button id="modal_createUser" class="text-white bg-zinc-900 text-sm cursor-pointer hover:bg-zinc-800 p-2 rounded-md hover:scale-105 transition-all ease-in-out flex items-center gap-2 outline-none">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                                <path d="M5.25 6.375a4.125 4.125 0 1 1 8.25 0 4.125 4.125 0 0 1-8.25 0ZM2.25 19.125a7.125 7.125 0 0 1 14.25 0v.003l-.001.119a.75.75 0 0 1-.363.63 13.067 13.067 0 0 1-6.761 1.873c-2.472 0-4.786-.684-6.76-1.873a.75.75 0 0 1-.364-.63l-.001-.122ZM18.75 7.5a.75.75 0 0 0-1.5 0v2.25H15a.75.75 0 0 0 0 1.5h2.25v2.25a.75.75 0 0 0 1.5 0v-2.25H21a.75.75 0 0 0 0-1.5h-2.25V7.5Z" />
                            </svg>
                            <span class="font-medium hidden sm:block">Nuevo usuario</span>
                        </button>
                    </nav>
                </article>
                <article class="flex flex-col gap-4">
                    <div class="flex flex-col gap-2 bg-zinc-50 p-4 rounded-lg">
                        <h3 class="text-zinc-600 text-sm">Listado de todos los usuarios (<?= count($users) ?>)</h3>
                        <?php include_once __DIR__.'/components/table/TableUsers.php'; ?>
                </article>
            </section>
        </div>
    </main>
    <script type="module" src="<?= $urlAbsolute ?>/js/pages/users/User.js"></script>
<?php include_once __DIR__.'/../includes/Footer.php'; ?>