<?php include_once __DIR__.'/../../../includes/Header.php'; ?>
    <main class="flex lg:flex-row xs:flex-col h-screen overflow-hidden w-screen bg-slate-50">
        <?php include_once __DIR__.'/../../../includes/Aside.php'; ?>
        <div class="px-5 xs:pt-0 lg:pt-5 w-full overflow-y-scroll pb-2">
            <section class="flex flex-col p-5 w-full gap-6 bg-white shadow rounded-lg h-fit">
                <article class="flex items-center justify-between">
                    <div class="flex flex-col gap-1">
                        <span class="text-zinc-500 text-sm font-medium">Configuración</span>
                        <h1 class="text-zinc-800 font-bold md:text-3xl xs:text-2xl">Configuración de la aplicación</h1>
                    </div>
                </article>
                <article class="flex flex-col gap-2">
                    <p class="text-sm text-zinc-500">En este apartado podras realizar ajustes del sistema, entre muchas otras cosas.</p>
                    <aside class="flex borde-b w-full overflow-hidden overflow-x-auto text-sm border-b border-b-zinc-100">
                        <a href="<?= $urlAbsolute.'/settings' ?>" class="font-medium rounded-t-lg p-2 px-4 border-b-2 
                            <?= $current === $urlAbsolute.'/settings' || rtrim($current, '/') === $urlAbsolute.'/settings' ? 'text-[#393784] bg-[#f8f8fc] border-[#393784]' : 'text-zinc-500 border-transparent hover:bg-zinc-100' ?>"
                        >General</a>
                        <?php if ($userSession->role->name === 'Administrador'): ?>
                            <a href="<?= $urlAbsolute.'/settings/administration' ?>" class="font-medium rounded-t-lg p-2 px-4 border-b-2 
                                <?= $current === $urlAbsolute.'/settings/administration' || rtrim($current, '/') === $urlAbsolute.'/settings/administration' ? 'text-[#393784] bg-[#f8f8fc] border-[#393784]' : 'text-zinc-500 border-transparent hover:bg-zinc-100' ?>"
                            >
                                Administración
                            </a>
                        <?php endif; ?>
                        <a href="<?= $urlAbsolute.'/settings/security' ?>" class="font-medium rounded-t-lg p-2 px-4 border-b-2 
                        <?= str_starts_with($current, $urlAbsolute.'/settings/security') ? 'text-[#393784] bg-[#f8f8fc] border-[#393784]' : 'text-zinc-500 border-transparent hover:bg-zinc-100' ?>"
                        >Seguridad</a>
                        <a href="<?= $urlAbsolute.'/settings/notifications' ?>" class="font-medium rounded-t-lg p-2 px-4 border-b-2
                        <?= str_starts_with($current, $urlAbsolute.'/settings/notifications') ? 'text-[#393784] bg-[#f8f8fc] border-[#393784]' : 'text-zinc-500 border-transparent hover:bg-zinc-100' ?>
                        ">Notificaciones</a>
                        <a href="<?= $urlAbsolute.'/settings/aparience' ?>" class="font-medium rounded-t-lg p-2 px-4 border-b-2
                        <?= str_starts_with($current, $urlAbsolute.'/settings/aparience') ? 'text-[#393784] bg-[#f8f8fc] border-[#393784]' : 'text-zinc-500 border-transparent hover:bg-zinc-100' ?>
                        ">Apariencia</a>
                    </aside>
                    <div class="flex flex-col gap-2">