<?php
$priorityColors = [
    'alta' => 'bg-red-100 text-red-700 border-red-300',
    'media' => 'bg-yellow-100 text-yellow-700 border-yellow-300',
    'baja' => 'bg-green-100 text-green-700 border-green-300',
];
?>

<div class="overflow-x-auto">
    <table class="min-w-full bg-white rounded-lg overflow-hidden">
        <thead class="bg-zinc-100">
            <tr>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Proyecto</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Cliente</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Inicio</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Fin</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Prioridad</th>
                <th class="text-center p-3 text-sm font-semibold text-gray-700">Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($projects as $project): ?>
                <?php $priorityClass = $priorityColors[$project->priority] ?? 'bg-gray-100 text-gray-700 border-gray-300'; ?>
                <tr class="border-t border-t-gray-200 hover:bg-gray-50 transition-colors">
                    <td class="p-3 text-sm text-gray-700 font-medium"><?= htmlspecialchars($project->name) ?></td>
                    <td class="p-3 text-sm text-gray-700"><?= htmlspecialchars($project->client->name_company) ?></td>
                    <td class="p-3 text-sm text-gray-600"><?= $project->start_date->format('d/m/Y') ?></td>
                    <td class="p-3 text-sm text-gray-600"><?= $project->end_date->format('d/m/Y') ?></td>
                    <td class="p-3 text-sm">
                        <span class="text-xs py-1 px-3 font-medium rounded-lg uppercase <?= $priorityClass ?>">
                            <?= htmlspecialchars($project->priority) ?>
                        </span>
                    </td>
                    <td class="p-3 text-center">
                        <div class="flex justify-center">
                            <a href="<?= $urlAbsolute ?>/projects/<?= $project->id ?>" class="flex gap-2 items-center hover:bg-white rounded-lg text-zinc-800 px-3 py-1">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                                    <path fill-rule="evenodd" d="M15.22 6.268a.75.75 0 0 1 .968-.431l5.942 2.28a.75.75 0 0 1 .431.97l-2.28 5.94a.75.75 0 1 1-1.4-.537l1.63-4.251-1.086.484a11.2 11.2 0 0 0-5.45 5.173.75.75 0 0 1-1.199.19L9 12.312l-6.22 6.22a.75.75 0 0 1-1.06-1.061l6.75-6.75a.75.75 0 0 1 1.06 0l3.606 3.606a12.695 12.695 0 0 1 5.68-4.974l1.086-.483-4.251-1.632a.75.75 0 0 1-.432-.97Z" clip-rule="evenodd" />
                                </svg>

                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
