  <div class="flex flex-col gap-4">
    <div class="flex flex-col">
      <nav id="breadcrumb" class="text-sm text-neutral-500 mb-1"></nav>
      <h1 id="titulo" class="text-2xl font-bold text-neutral-800 tracking-tight">📁 Etapas del Proyecto</h1>
    </div>

    <div class="flex justify-end w-full sm:w-auto mb-2">
      <button id="volver" class="hidden flex flex-row items-center gap-2 text-sm hover:scale-105 text-neutral-700 border border-neutral-300 px-4 py-2 rounded-lg hover:bg-neutral-200 transition-all ease-in-out cursor-pointer">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
        </svg>
        <span>Volver</span>
      </button>
    </div>
  </div>
  
  <div class="flex xs:flex-col sm:flex-row gap-2">
    <div class="flex flex-col w-full gap-1 bg-zinc-100 p-5 rounded-lg h-fit border border-zinc-200">
      <h3 class="text-sm text-zinc-600 font-medium">Etapas</h3>
      <div id="arbol" class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-2 w-full justify-items-center"></div>
    </div>
    <div id="infoEtapa" class="w-full flex flex-col mb-2 hidden border border-zinc-200 rounded-lg p-4 bg-white shadow-sm">
      <h2 class="text-lg font-semibold text-neutral-800 mb-2">Detalles de la Etapa</h2>
      <div id="detallesEtapa" class="text-sm text-neutral-600 space-y-1"></div>

      <div id="documentosEtapa" class="mt-4">
        <h3 class="font-medium text-neutral-700 mb-1">📄 Documentos</h3>
        <div id="listaDocumentos" class="text-sm text-neutral-500 italic">No hay documentos disponibles.</div>
      </div>
    </div>
  </div>


<script type="module">
  const stages = <?= json_encode($project->stages) ?>;

  let currentStage = null;
  const rootStages = stages; // Etapas principales (puede haber varias)

  const arbol = document.getElementById("arbol");
  const volver = document.getElementById("volver");
  const titulo = document.getElementById("titulo");
  const breadcrumb = document.getElementById("breadcrumb");

  function renderStage(stage) {
    arbol.innerHTML = "";
    const infoEtapa = document.getElementById("infoEtapa");
    const detallesEtapa = document.getElementById("detallesEtapa");
    const listaDocumentos = document.getElementById("listaDocumentos");

    if (!stage) {
      // Modo raíz (todas las etapas principales)
      titulo.textContent = "📁 Etapas del Proyecto";
      volver.classList.add("hidden");
      infoEtapa.classList.add("hidden");
      renderBreadcrumb([{ name: "Inicio" }]);

      if (rootStages.length === 0) {
        arbol.innerHTML = '<p class="text-gray-500 italic">No hay etapas</p>';
        return;
      }

      rootStages.forEach((root) => {
        const div = document.createElement("div");
        div.className =
          "etapa w-full h-full border border-zinc-200 p-5 rounded-lg shadow-sm hover:shadow-md cursor-pointer transition bg-white";
        div.innerHTML = `
          <div class="font-semibold text-lg mb-1">${root.name}</div>
          <div class="text-sm text-gray-400">${root.status ?? ""}</div>
        `;
        div.addEventListener("click", () => {
          currentStage = root;
          renderStage(root);
        });
        arbol.appendChild(div);
      });
      return;
    }

    // Etapa activa (mostrar detalles)
    titulo.textContent = `📁 ${stage.name}`;
    volver.classList.remove("hidden");
    infoEtapa.classList.remove("hidden");

    const path = getStagePathMultiple(rootStages, stage.id);
    renderBreadcrumb(path);

    // --- Detalles de la etapa ---
    detallesEtapa.innerHTML = `
      <p><strong>Nombre:</strong> ${stage.name}</p>
      <p><strong>Descripción:</strong> ${stage.description || "Sin descripción"}</p>
      <p><strong>Estado:</strong> <span class="capitalize">${stage.status || "No definido"}</span></p>
      <p><strong>Fecha inicio:</strong> ${stage.start_date || "—"}</p>
      <p><strong>Fecha fin:</strong> ${stage.end_date || "—"}</p>
    `;

    // --- Documentos ---
    if (stage.documents && stage.documents.length > 0) {
      listaDocumentos.classList.remove("italic", "text-neutral-500");
      listaDocumentos.innerHTML = "";
      stage.documents.forEach((doc) => {
        const li = document.createElement("div");
        li.className = "flex items-center gap-2 border-b border-neutral-200 py-1";
        li.innerHTML = `
          <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4 text-blue-500">
            <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 0 0-3.375-3.375H8.25M4.5 19.5V6.75a3.75 3.75 0 0 1 3.75-3.75h7.5a3.75 3.75 0 0 1 3.75 3.75V19.5m-12 0h12" />
          </svg>
          <a href="${doc.url}" target="_blank" class="text-blue-600 hover:underline">${doc.name}</a>
        `;
        listaDocumentos.appendChild(li);
      });
    } else {
      listaDocumentos.classList.add("italic", "text-neutral-500");
      listaDocumentos.textContent = "No hay documentos disponibles.";
    }

    // --- Subetapas ---
    if (!stage.children || stage.children.length === 0) {
      arbol.innerHTML =
        '<p class="text-gray-500 italic col-span-full mt-4">No hay subetapas</p>';
      return;
    }

    stage.children.forEach((sub) => {
      const div = document.createElement("div");
      div.className =
        "etapa w-full h-full border border-zinc-200 p-5 rounded-lg shadow-sm hover:shadow-md cursor-pointer transition bg-white";
      div.innerHTML = `
        <div class="font-semibold text-lg mb-1">${sub.name}</div>
        <div class="text-sm text-gray-400">${sub.status ?? ""}</div>
      `;
      div.addEventListener("click", () => {
        currentStage = sub;
        renderStage(sub);
      });
      arbol.appendChild(div);
    });
  }
  // 🔹 Encuentra la ruta en múltiples raíces
  function getStagePathMultiple(roots, targetId) {
    for (const root of roots) {
      const path = getStagePath(root, targetId);
      if (path) return path;
    }
    return [{ name: "Inicio" }];
  }

  // 🔹 Encuentra la ruta dentro de un árbol
  function getStagePath(stage, targetId, path = []) {
    path.push(stage);
    if (stage.id === targetId) return path;
    if (!stage.children) return null;

    for (const child of stage.children) {
      const found = getStagePath(child, targetId, [...path]);
      if (found) return found;
    }
    return null;
  }

  // Render breadcrumb
  function renderBreadcrumb(path) {
    breadcrumb.innerHTML = "";

    const frag = document.createDocumentFragment();

    path.forEach((etapa, index) => {
      const span = document.createElement("span");
      span.textContent = etapa.name;

      if (index < path.length - 1 && etapa.id) {
        span.classList.add("text-blue-600", "cursor-pointer", "hover:underline");
        span.addEventListener("click", () => {
          currentStage = etapa;
          renderStage(etapa);
        });
      } else {
        span.classList.add("text-neutral-700", "font-medium");
      }

      frag.appendChild(span);

      if (index < path.length - 1) {
        const separator = document.createElement("span");
        separator.textContent = " › ";
        separator.classList.add("text-neutral-400");
        frag.appendChild(separator);
      }
    });

    breadcrumb.appendChild(frag);
  }

  // Botón volver
  volver.addEventListener("click", () => {
    if (!currentStage) return renderStage(null);

    function findParent(stage, targetId) {
      if (!stage.children) return null;
      for (const child of stage.children) {
        if (child.id === targetId) return stage;
        const found = findParent(child, targetId);
        if (found) return found;
      }
      return null;
    }

    let parent = null;
    for (const root of rootStages) {
      parent = findParent(root, currentStage.id);
      if (parent) break;
    }

    if (parent) {
      currentStage = parent;
      renderStage(parent);
    } else {
      currentStage = null;
      renderStage(null);
    }
  });

  // Render inicial
  renderStage(null);
</script>
