<div class="grid 2xl:grid-cols-4 xl:grid-cols-3 lg:grid-cols-3 md:grid-cols-2 gap-2 overflow-x-auto overflow-hidden p-2">
    <?php foreach($myProjects as $project): ?>
        <div class="cursor-pointer border border-gray-200 rounded-xl hover:shadow-md hover:scale-102 transition-all ease-in-out overflow-hidden w-full flex flex-col justify-between">
            <!-- Encabezado del proyecto -->
            <div class="bg-gradient-to-r from-[#6c67c0] to-[#201d6b] p-4 h-full flex flex-col gap-1">
                <h2 class="text-xl font-bold text-white"><?= htmlspecialchars($project->name) ?></h2>
                <p class="text-sm text-zinc-100"><?= htmlspecialchars($project->client->name_company) ?></p>
                <div class="flex gap-2 justify-end mt-2">
                    <p class="text-gray-300 text-xs"><?= $project->start_date->format('d/m/Y') ?></p>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4 text-zinc-300">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M17.25 8.25 21 12m0 0-3.75 3.75M21 12H3" />
                        </svg>
                    <p class="text-gray-300 text-xs"><?= $project->end_date->format('d/m/Y') ?></p>
                </div>
            </div>

            <!-- Contenido del proyecto -->
            <div class="p-4 flex justify-between">
                <div class="flex flex-col ">
                    <span class="text-xs text-zinc-500 font-medium">Etapa en curso:</span>
                    <span class="text-sm text-zinc-800">Planeación y estrategia</span>
                </div>
                <a href="<?= $urlAbsolute ?>/projects/<?= $project->id ?>" class="flex gap-2 items-center bg-zinc-50 hover:bg-zinc-100 rounded-lg text-zinc-800 px-3 py-1">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd" d="M15.22 6.268a.75.75 0 0 1 .968-.431l5.942 2.28a.75.75 0 0 1 .431.97l-2.28 5.94a.75.75 0 1 1-1.4-.537l1.63-4.251-1.086.484a11.2 11.2 0 0 0-5.45 5.173.75.75 0 0 1-1.199.19L9 12.312l-6.22 6.22a.75.75 0 0 1-1.06-1.061l6.75-6.75a.75.75 0 0 1 1.06 0l3.606 3.606a12.695 12.695 0 0 1 5.68-4.974l1.086-.483-4.251-1.632a.75.75 0 0 1-.432-.97Z" clip-rule="evenodd" />
                    </svg>
                </a>
            </div>
        </div>
    <?php endforeach; ?>
</div>
