<?php
$priorityColors = [
    'alta' => 'bg-red-100 text-red-700 border-red-300',
    'media' => 'bg-yellow-100 text-yellow-700 border-yellow-300',
    'baja' => 'bg-green-100 text-green-700 border-green-300',
];
?>

<?php include_once __DIR__.'/../includes/Header.php'; ?>
        <main class="flex lg:flex-row xs:flex-col h-screen overflow-hidden bg-slate-50">
        <?php include_once __DIR__.'/../includes/Aside.php'; ?>
        <?php $priorityClass = $priorityColors[$project->priority] ?? 'bg-gray-100 text-gray-700 border-gray-300'; ?>
        <div class="px-5 xs:pt-0 lg:pt-5 w-full overflow-y-scroll pb-2">
            <section class="flex flex-col p-5 w-full gap-6 bg-white shadow rounded-lg h-fit">
                <a href="<?= $urlAbsolute ?>/projects" class="flex items-center gap-2 text-zinc-500 hover:bg-zinc-100 hover:scale-105 w-fit p-2 rounded-lg transition-all ease-in-out">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 15 3 9m0 0 6-6M3 9h12a6 6 0 0 1 0 12h-3" />
                    </svg>
                    <span class=" text-sm font-medium">Regresar</span>
                </a>
                <article class="flex xs:flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                    <div class="flex flex-col gap-1">
                        <div class="flex items-center gap-1">
                            <a href="<?= $urlAbsolute ?>/projects" class="text-[#393784] text-sm font-medium">Proyectos /</a>
                            <span class="text-zinc-500 text-sm font-medium"><?= $project->name ?></span>
                        </div>
                        <h1 class="text-zinc-800 font-bold md:text-4xl xs:text-3xl"><?= $project->name ?></h1>
                    </div>
                    <div class="flex gap-2 items-center">
                        <?php if (in_array($userSession->role->name, ['Administrador', 'Project Manager'])): ?>
                            <button id="modal_createProtectedUrl" class="text-[#393784] bg-[#eeedfa] hover:bg-[#e6e4fc] p-2 rounded-lg hover:scale-105 transition-all ease-in-out cursor-pointer flex gap-2 items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                                    <path fill-rule="evenodd" d="M15.75 4.5a3 3 0 1 1 .825 2.066l-8.421 4.679a3.002 3.002 0 0 1 0 1.51l8.421 4.679a3 3 0 1 1-.729 1.31l-8.421-4.678a3 3 0 1 1 0-4.132l8.421-4.679a3 3 0 0 1-.096-.755Z" clip-rule="evenodd" />
                                </svg>
                                <span class="text-sm">Compartir</span>
                            </button>
                        <?php endif; ?>
                        <a href="<?= $urlAbsolute ?>/projects/<?= $project->id ?>/download" id="downloadProjectBtn" class="text-zinc-700 bg-zinc-50 p-2 rounded-lg hover:bg-zinc-100 hover:scale-105 transition-all ease-in-out cursor-pointer flex gap-2 items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                                <path fill-rule="evenodd" d="M12 2.25a.75.75 0 0 1 .75.75v11.69l3.22-3.22a.75.75 0 1 1 1.06 1.06l-4.5 4.5a.75.75 0 0 1-1.06 0l-4.5-4.5a.75.75 0 1 1 1.06-1.06l3.22 3.22V3a.75.75 0 0 1 .75-.75Zm-9 13.5a.75.75 0 0 1 .75.75v2.25a1.5 1.5 0 0 0 1.5 1.5h13.5a1.5 1.5 0 0 0 1.5-1.5V16.5a.75.75 0 0 1 1.5 0v2.25a3 3 0 0 1-3 3H5.25a3 3 0 0 1-3-3V16.5a.75.75 0 0 1 .75-.75Z" clip-rule="evenodd" />
                            </svg>
                            <span class="text-sm">Descargar</span>
                        </a>
                    </div>
                </article>
                <article class="flex flex-col gap-4">
                    <div class="flex sm:flex-row xs:flex-col sm:justify-between items-start gap-2">
                        <div class="flex flex-col gap-2 items-start w-full h-full bg-zinc-50 rounded-lg p-4">
                            <!-- <input id="projectIdInput" value="<?= $project->id ?>" hidden > -->
                            <h3 class="text-zinc-600 text-sm pb-2 border-b border-b-zinc-200 w-full font-medium">Información general</h3>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Cliente: </span>
                                <span class="font-medium text-zinc-700"><?= $project->client->name_company ?></span>
                            </div>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Nombre de contacto: </span>
                                <span class="font-medium text-zinc-700"><?= $project->client->name_contact ?></span>
                            </div>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Telefono de contacto: </span>
                                <span class="font-medium text-zinc-700"><?= $project->client->phone_contact ?></span>
                            </div>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Correo de contacto: </span>
                                <span class="font-medium text-zinc-700"><?= $project->client->email_contact ?? "--" ?></span>
                            </div>
                        </div>
                        <div class="flex flex-col gap-2 items-start w-full bg-zinc-50 h-full rounded-lg p-4">
                            <h3 class="text-zinc-600 text-sm pb-2 border-b border-b-zinc-200 w-full font-medium">Información del proyecto</h3>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Fecha de inicio: </span>
                                <span class="font-medium text-zinc-700"><?= $project->start_date->format('d-M-Y'); ?></span>
                                
                            </div>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Fecha de finalización: </span>
                                <span class="font-medium text-zinc-700"><?= $project->end_date->format('d-M-Y'); ?></span>
                                
                            </div>
                            <div class="flex justify-between items-center w-full md:flex-row xs:flex-col xs:items-start">
                                <span class="text-zinc-500">Prioridad</span>
                                <span class="text-xs py-1 px-3 font-medium rounded-lg uppercase <?= $priorityClass ?>">
                                    <?= htmlspecialchars($project->priority) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col gap-2 border-t border-zinc-200 pt-4">
                        <div class="flex items-center justify-between">
                            <h3 class="text-zinc-600 text-sm font-medium">Detalle del proyecto</h3>
                            <?php if (in_array($userSession->role->name, ['Administrador', 'Project Manager'])): ?>
                                <button id="modal_ListMembers" class="text-[#393784] bg-[#eeedfa] p-2 rounded-lg hover:bg-[#e6e4fc] hover:scale-105 transition-all ease-in-out cursor-pointer flex gap-2 items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                                        <path fill-rule="evenodd" d="M8.25 6.75a3.75 3.75 0 1 1 7.5 0 3.75 3.75 0 0 1-7.5 0ZM15.75 9.75a3 3 0 1 1 6 0 3 3 0 0 1-6 0ZM2.25 9.75a3 3 0 1 1 6 0 3 3 0 0 1-6 0ZM6.31 15.117A6.745 6.745 0 0 1 12 12a6.745 6.745 0 0 1 6.709 7.498.75.75 0 0 1-.372.568A12.696 12.696 0 0 1 12 21.75c-2.305 0-4.47-.612-6.337-1.684a.75.75 0 0 1-.372-.568 6.787 6.787 0 0 1 1.019-4.38Z" clip-rule="evenodd" />
                                        <path d="M5.082 14.254a8.287 8.287 0 0 0-1.308 5.135 9.687 9.687 0 0 1-1.764-.44l-.115-.04a.563.563 0 0 1-.373-.487l-.01-.121a3.75 3.75 0 0 1 3.57-4.047ZM20.226 19.389a8.287 8.287 0 0 0-1.308-5.135 3.75 3.75 0 0 1 3.57 4.047l-.01.121a.563.563 0 0 1-.373.486l-.115.04c-.567.2-1.156.349-1.764.441Z" />
                                    </svg>
                                    <span class="text-sm">Integrantes</span>
                                </button>
                            <?php endif; ?>
                        </div>
                        <div class="flex xs:flex-col lg:flex-row gap-2 h-fit relative">
                            <?php if(count($project->stages) > 0): ?>
                               <?php require __DIR__.'/components/list/ListStagesProject.php'; ?>
                               <div id="stage-details" class="bg-zinc-50 p-5 w-full rounded-lg border border-dashed border-zinc-300 h-fit sticky top-2">
                                    <div class="w-full h-full flex flex-col justify-center items-center gap-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-16 text-zinc-400/80">
                                            <path fill-rule="evenodd" d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm11.378-3.917c-.89-.777-2.366-.777-3.255 0a.75.75 0 0 1-.988-1.129c1.454-1.272 3.776-1.272 5.23 0 1.513 1.324 1.513 3.518 0 4.842a3.75 3.75 0 0 1-.837.552c-.676.328-1.028.774-1.028 1.152v.75a.75.75 0 0 1-1.5 0v-.75c0-1.279 1.06-2.107 1.875-2.502.182-.088.351-.199.503-.331.83-.727.83-1.857 0-2.584ZM12 18a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" clip-rule="evenodd" />
                                        </svg>

                                        <span class="text-sm text-zinc-500">Es necesario que selecciones una etapa para visualizar su contenido</span>
                                    </div>
                               </div>
                            <?php else: ?>
                                <div class="add-root-stage-btn w-full h-full cursor-pointer border border-white hover:border-zinc-200 hover:scale-101 transition-all ease-in-out col-span-5 text-zinc-400 flex flex-col items-center justify-center p-10 gap-2 bg-zinc-50 rounded-lg ">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-12">
                                        <path fill-rule="evenodd" d="M19.5 21a3 3 0 0 0 3-3V9a3 3 0 0 0-3-3h-5.379a.75.75 0 0 1-.53-.22L11.47 3.66A2.25 2.25 0 0 0 9.879 3H4.5a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h15Zm-6.75-10.5a.75.75 0 0 0-1.5 0v2.25H9a.75.75 0 0 0 0 1.5h2.25v2.25a.75.75 0 0 0 1.5 0v-2.25H15a.75.75 0 0 0 0-1.5h-2.25V10.5Z" clip-rule="evenodd" />
                                    </svg>
                                    <p class="text-sm">Empieza por crea una primer etapa</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </article>
            </section>
        </div>
    </main>
    <script type="module" src="<?= $urlAbsolute ?>/js/pages/project/ProjectDetail.js"></script>
<?php include_once __DIR__.'/../includes/Footer.php'; ?>