<?php include_once __DIR__.'/../includes/Header.php'; ?>
        <main class="flex lg:flex-row xs:flex-col h-screen overflow-hidden w-screen bg-slate-50">
        <?php include_once __DIR__.'/../includes/Aside.php'; ?>
        <div class="px-5 xs:pt-0 lg:pt-5 w-full overflow-y-scroll pb-2">
            <section class="flex flex-col p-5 w-full gap-6 bg-white shadow rounded-lg h-fit">
                <article class="flex items-center justify-between">
                    <div class="flex flex-col gap-1">
                        <span class="text-zinc-500 text-sm font-medium">Proyectos</span>
                        <h1 class="text-zinc-800 font-bold md:text-3xl xs:text-2xl">Gestión de proyectos</h1>
                    </div>
                    <nav class="flex gap-2 items-center">
                        <?php if ($userSession->role->name === 'Administrador'): ?>
                            <button id="modal_createProject" class="text-white bg-zinc-900 text-sm cursor-pointer hover:bg-zinc-800 p-2 rounded-md hover:scale-105 transition-all ease-in-out flex items-center gap-2 outline-none">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                                    <path fill-rule="evenodd" d="M19.5 21a3 3 0 0 0 3-3V9a3 3 0 0 0-3-3h-5.379a.75.75 0 0 1-.53-.22L11.47 3.66A2.25 2.25 0 0 0 9.879 3H4.5a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h15Zm-6.75-10.5a.75.75 0 0 0-1.5 0v2.25H9a.75.75 0 0 0 0 1.5h2.25v2.25a.75.75 0 0 0 1.5 0v-2.25H15a.75.75 0 0 0 0-1.5h-2.25V10.5Z" clip-rule="evenodd" />
                                </svg>
                                <span class="font-medium hidden sm:block">Nuevo proyecto</span>
                            </button>
                        <?php endif; ?>
                    </nav>
                </article>
                <article class="flex flex-col gap-4">
                    <div class="flex flex-col gap-2 border border-zinc-200 p-2 rounded-lg">
                        <h3 class="text-zinc-600 text-sm">Mis Proyectos (<?= count($myProjects) ?>)</h3>
                        <?php if(count($myProjects) > 0): ?>
                            <?php include_once __DIR__.'/components/list/ListProjects.php'; ?>
                        <?php else: ?>
                                <div class="text-zinc-400 flex flex-col items-center justify-center p-10 gap-2 bg-zinc-50 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-12">
                                        <path d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0 0 16.5 9h-1.875a1.875 1.875 0 0 1-1.875-1.875V5.25A3.75 3.75 0 0 0 9 1.5H5.625Z" />
                                        <path d="M12.971 1.816A5.23 5.23 0 0 1 14.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 0 1 3.434 1.279 9.768 9.768 0 0 0-6.963-6.963Z" />
                                    </svg>
                                    <p class="text-sm">No tienes proyectos asignados.</p>
                                </div>
                        <?php endif; ?>
                    </div>
                    <?php if ($userSession->role->name === 'Administrador'): ?>
                        <div class="flex flex-col gap-2 bg-zinc-50 p-4 rounded-lg">
                            <h3 class="text-zinc-600 text-sm">Listado de todos los proyectos (<?= count($projects) ?>)</h3>
                            <?php if(count($projects) > 0): ?>
                                <?php include_once __DIR__.'/components/table/TableProjects.php'; ?>
                            <?php else: ?>
                                    <p>No hay proyectos que mostrar.</p>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </article>
            </section>
        </div>
    </main>
    <script type="module" src="<?= $urlAbsolute ?>/js/pages/project/Project.js"></script>
<?php include_once __DIR__.'/../includes/Footer.php'; ?>