<div class="overflow-x-auto">
    <table class="min-w-full bg-white rounded-lg overflow-hidden">
        <thead class="bg-zinc-100">
            <tr>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Empresa</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Contacto</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Teléfono de contacto</th>
                <th class="text-left p-3 text-sm font-semibold text-gray-700">Email de contacto</th>
                <th class="text-center p-3 text-sm font-semibold text-gray-700">Estado</th>
                <th class="text-center p-3 text-sm font-semibold text-gray-700">Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($clients as $client): ?>
                <tr class="border-t border-t-gray-200 hover:bg-gray-50 transition-colors">
                    <td class="p-3 text-sm text-gray-700 font-medium"><?= htmlspecialchars($client->name_company) ?></td>
                    <td class="p-3 text-sm text-gray-700"><?= htmlspecialchars($client->name_contact) ?></td>
                    <td class="p-3 text-sm text-gray-600"><?= htmlspecialchars($client->phone_contact) ?></td>
                    <td class="p-3 text-sm text-gray-600"><?= htmlspecialchars($client->email_contact) ?></td>
                    <td class="p-3 text-sm text-gray-600 text-center">
                        <button id="btnDeleteClient" data-client="<?= htmlspecialchars($client->id) ?>" class="cursor-pointer">
                            <?php if($client->isActive == true): ?>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5 text-green-500">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                </svg>
                            <?php else: ?>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5 text-red-500">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 18.364A9 9 0 0 0 5.636 5.636m12.728 12.728A9 9 0 0 1 5.636 5.636m12.728 12.728L5.636 5.636" />
                                </svg>
                            <?php endif; ?>
                        </button>
                    </td>
                    <td class="p-3 text-sm" align="center">
                        <button class="text-[#464574] cursor-pointer" data-client="<?= htmlspecialchars(json_encode($client)) ?>" id="modal_editClient">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                            </svg>
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
