<?php

namespace App\Services;

use App\Models\Client;
use App\Repositories\ClientRepository;
use Exception;

class ClientService {

    private ClientRepository $clientRepository;

    public function __construct() {
        $this->clientRepository = new ClientRepository();
    }

    public function getAllClients(): array
    {
        $clients = $this->clientRepository->getAll();

        return $clients;
    }

    public function getClientById(int $clientId): Client
    {
        return $this->clientRepository->findBy("id", $clientId);
    }

    public function createClient(Client $client): Client
    {
        $clientId = $this->clientRepository->create($client);
        
        if(!$clientId){
            throw new Exception("Hubo un error al crear el cliente.", 500);
        }

        return $this->getClientById($clientId);
    }

    public function updateClient(Client $client): Client
    {
        if(!$this->clientRepository->update($client)){
            throw new Exception("Hubo un error al actualizar el cliente.", 500);
        }

        return $this->getClientById($client->id);
    }

    public function changeStatusClient(int $clientId): Client
    {
        if(!$this->clientRepository->changeStatus($clientId)){
            throw new Exception("Hubo un error al cambiar el estado del cliente.", 500);
        }

        return $this->getClientById($clientId);
    }
}