<?php

namespace App\Routes;

use App\Core\Router;
use App\Controllers\StageController;

/** @var Router $router */

$router->post('/stages', StageController::class, 'create');
$router->get('/stage/{stageId}', StageController::class, 'show');
$router->put('/stage/{stageId}', StageController::class, 'update');
$router->delete('/stage/{stageId}', StageController::class, 'delete');

$router->put('/stage/{stageId}/traffic-light', StageController::class, 'updateTrafficLight');
$router->put('/stage/{stageId}/move', StageController::class, 'move');

// Exportar y guardar estructura
$router->get('/project/{projectId}/stages/export', StageController::class, 'exportStructure');
$router->post('/project/{projectId}/stages/save-default', StageController::class, 'saveAsDefault');