<?php

namespace App\Routes;

use App\Core\Router;
use App\Controllers\ProjectController;
use App\Controllers\ProtectedUrlController;

/** @var Router $router */

$router->get('/projects', ProjectController::class, 'index');
$router->post('/projects', ProjectController::class, 'create');
$router->get('/projects/{projectId}/download', ProjectController::class, 'download');
$router->get('/projects/{id}', ProjectController::class, 'show');

$router->get('/projects/{projectId}/users', ProjectController::class, 'getMembers');
$router->delete('/projects/{projectId}/users/{userId}', ProjectController::class, 'removeMember');
$router->post('/projects/users', ProjectController::class, 'addMember');

$router->post('/project/shared', ProtectedUrlController::class, 'create');
$router->get('/project/shared/{projectId}', ProtectedUrlController::class, 'show');
$router->get('/project/shared', ProtectedUrlController::class, 'access');