<?php

namespace App\Repositories;

use App\Config\ContextDB;
use App\Models\Role;
use PDO;

use function PHPSTORM_META\map;

class RoleRepository
{
    private PDO $context;

    public function __construct(){
        $this->context = (new ContextDB())->conn;
    }

    public function getAll()
    {
        $consult = $this->context->prepare("
            SELECT id, name
            FROM roles;
        ");

        $consult->execute();

        $response = array_map(fn($item) => new Role($item), $consult->fetchAll(PDO::FETCH_ASSOC));
        return $response;
    }   
}
