<?php

namespace App\Models;

use App\Models\Client;
use App\Models\User;
use DateTime;

class Project {
    public ?int $id = null;
    public string $name = "";
    public int $client_id;
    public DateTime $start_date;
    public DateTime $end_date;
    public string $status;
    public string $priority;
    public float $budget;
    public float $current_cost;
    public int $user_created;
    

    public ?User $user = null;
    public ?Client $client = null;
    public ?ProtectedUrl $shared_url = null;

    /** @var Stage[] */
    public array $stages = [];

    public function __construct(array $data = []) {
        if (!empty($data)) {
            $this->id = $data['id'] ?? null;
            $this->name = $data['name'] ?? '';
            $this->client_id = $data['client_id'] ?? 0;

            // Convierte strings a DateTime
            $this->start_date = isset($data['start_date']) ? new DateTime($data['start_date']) : new DateTime();
            $this->end_date   = isset($data['end_date']) ? new DateTime($data['end_date']) : new DateTime();

            $this->status = $data['status'] ?? '';
            $this->priority = $data['priority'] ?? '';
            $this->budget = $data['budget'] ?? 0.0;
            $this->current_cost = $data['current_cost'] ?? 0.0;
            $this->user_created = $data['user_created'] ?? 0;
            $this->shared_url = isset($data['shared_url']) ? new ProtectedUrl($data['shared_url']) : null;
            $this->stages = $data['stages'] ?? [];

            // Aquí opcionalmente puedes inicializar los objetos relacionados
            if (isset($data['user'])) {
                $this->user = new User($data['user']);
            }
            if (isset($data['client'])) {
                $this->client = new Client($data['client']);
            }
        }
    }
}