Comando para optimizar composer : composer install --no-dev --optimize-autoloader

# **M2M - Project Manager**

## Estructura del proyecto

El proyecto se organiza de la siguiente manera:

1. **`/public`** : Contiene la capa de cliente. Aquí se incluyen los recursos estáticos (CSS, JavaScript, imágenes y demás  *assets* ) junto con el `index.php`, encargado de servir la aplicación al cliente.
2. **`/Server`** : Carpeta principal de la aplicación. Contiene la lógica del negocio, controladores, modelos, rutas y configuraciones.
3. **`/vendor`** : Librerías externas administradas por  *Composer* .
4. **`Readme.md`** : Documentación principal del proyecto.

---

## Recomendaciones de desarrollo

Este proyecto se implementa bajo un enfoque  **híbrido** : combina características de un sistema **monolítico** y de una  **API REST** . La arquitectura está diseñada para garantizar  **escalabilidad** , **mantenibilidad** y  **extensión sencilla de funcionalidades** .

Para asegurar consistencia, es recomendable seguir el  **Flujo recomendado de desarrollo** . En caso de duda, revisar archivos existentes de la misma capa para entender la convención aplicada y reutilizar patrones.

---

## Flujo recomendado de desarrollo

El proyecto implementa el  **Patrón Repositorio** , lo que facilita la separación de responsabilidades y el desacoplamiento entre capas.

El flujo de una solicitud es el siguiente:

**Router ➝ Ruta ➝ Controlador ➝ Servicio ➝ Repositorio ➝ Base de datos**

1. **Definición de la ruta de solicitud**
   * Toda nueva funcionalidad debe iniciar en la capa de  **rutas** , ubicada en `Server/Routes/`.
   * Si la feature corresponde a una entidad existente, la ruta se declara en el archivo correspondiente.
   * Si introduce una nueva entidad, se debe crear un  **nuevo archivo de rutas** , siguiendo las convenciones de los archivos existentes.
   * No olvidar **importar la ruta en `web.php`** para habilitar su funcionamiento.
2. **Definición del controlador**
   * El controlador es responsable de:
     * Recibir y validar la  **request** .
     * Aplicar **middleware** o validaciones de seguridad (proteger rutas).
     * Delegar la lógica de negocio a los  **servicios** .
     * Preparar y devolver la  **respuesta** , ya sea:
       * **Vista renderizada** (HTML/PHP).
       * **Respuesta JSON** (cuando se consuma como API).
   * Los controladores deben mantenerse  **delgados** : no deben implementar lógica de negocio, solo  **orquestar** .
   * El proyecto dispone de utilidades reutilizables para (core/herlpers - core/middlewares) :
     * Proteger rutas.
     * Validar tipo de solicitud (GET, POST, etc.).
     * Acceder a la  **request** .
     * Responder como **API** o como  **vista** .
3. **Servicios**
   * Los **servicios** encapsulan la lógica de negocio.
   * Son responsables de:
     * Ejecutar reglas de negocio.
     * Coordinar llamadas a otros servicios si fuera necesario.
     * Interactuar con los repositorios para acceder a datos.
   * El servicio debe ser lo más **puro y testeable** posible, evitando dependencias directas con el framework.
4. **Repositorios**
   * Los repositorios manejan la  **persistencia de datos** .
   * Se encargan de:
     * Consultar la base de datos.
     * Realizar inserciones, actualizaciones o eliminaciones.
     * Mapear resultados a **entidades tipadas** (para mayor seguridad y experiencia de desarrollo).
   * Gracias a esta capa, es posible desacoplar la aplicación de la implementación de la base de datos, facilitando cambios futuros (ejemplo: migrar de MySQL a PostgreSQL sin modificar servicios/controladores).
