<?php
require_once __DIR__ . '/../app/controllers/EventController.php';
require_once __DIR__ . '/../app/controllers/BlogController.php';
require_once __DIR__ . '/../app/controllers/GalleryController.php';

header('Content-Type: application/json');

$uploadMap = [
    'event_banner'   => ['EventController', 'uploadBanner'],
    'blog_img'      => ['BlogController', 'uploadImg'],
    'gallery_images_en' => ['GalleryController', 'uploadImage'],
];


foreach ($uploadMap as $field => $handler) {
    if (isset($_FILES[$field])) {
        call_user_func([$handler[0], $handler[1]], $_FILES[$field]);
        exit;
    }
}


echo json_encode([
    'success' => false,
    'message' => 'No se recibió ningún archivo válido'
]);
exit;