$(() => {
    $('#videosTable').DataTable({
        processing: true,
        ordering: false,
        ajax: {
            url: './routes/web.php',
            type: 'GET',
            data: function (d) {
                d.REQUEST_URI = '/videos/list'
            },
            dataSrc: 'videos'
        },
        columns: [
            { data: 'id' },
            { data: 'link' ,
                render: function(data,type,row,meta){
                    return row.link.length > 20 ? row.link.substring(0,20) + '...' : row.link
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return row.status ? `<span class="badge text-bg-success">Activo</span>` : '<span class="badge text-bg-danger">Inactivo</span>'
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return `
                    <a class="btn btn-primary" href="?page=edit-video&id=${row.id}">
                        <i class="fa-solid fa-pen"></i>
                    </a>
                    ${row.status
                            ? `<button class="btn btn-success" onclick="activateVideo(${row.id},0)">
                        <i class="fa-solid fa-check"></i>
                       </button>`
                            : ` <button class="btn btn-danger" onclick="activateVideo(${row.id},1)">
                         <i class="fa-solid fa-x"></i>
                        </button>`}
                    `
                }
            }
        ],
        language: {
            url: 'public/assets/datatables/es-Es.json',
        },
    })


})
function activateVideo(id, status) {
    Swal.fire({
        title: `${status ? 'Activar' : 'Desactivar'} Video`,
        text: `¿Estás seguro de ${status ? 'Activar' : 'Desactivar'} este video?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: `${status ? '#198754' : '#dc3545'}`,
        cancelButtonColor: "#808080",
        confirmButtonText: `${status ? 'Activar' : 'Desactivar'}`
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/videos/status', id: id, status: status },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Estado actualizado',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#videosTable').DataTable().ajax.reload();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                },
                error: (xhr, status, error) => {
                    console.log('Error: ', error, xhr, status)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        }
    });
}