$(() => {
    $('#eventsTable').DataTable({
        processing: true,
        ordering: false,
        pageLength: 10,
        ajax: {
            url: './routes/web.php',
            type: 'GET',
            data: function (d) {
                d.REQUEST_URI = '/events/list'
            },
            dataSrc: 'events'
        },
        columns: [
            { data: 'id' },
            { data: 'banner',
                render: function (data, type, row, meta) {
                    return `<div style="width: 100px; height: 100px; display: flex; align-items: center; justify-content: center; overflow: hidden; border-radius: 12px; background: #f3f3f3;">
                        <img src="./resources/images/events/${data}" alt="Banner" style="width: 100%; height: 100%; object-fit: cover; object-position: center; display: block;">
                    </div>`
                } 
            },
            { data: 'name',
                render: function(data,type,row,meta){
                    return row.name.length > 15 ? row.name.substring(0,20) + '...' : row.name
                }
            },
            { data: 'place',
                render: function(data,type, row,meta){
                    return row.place.length > 15 ? row.place.substring(0,15) + '...' : row.place
                }
            },
            {
                data: 'date',
                render: function (data, type, row, meta) {
                    if (!data) return '';
                    const [year, month, day] = data.split('-');
                    return `${day}-${month}-${year}`;
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return row.status ? `<span class="badge text-bg-success">Activo</span>` : '<span class="badge text-bg-danger">Inactivo</span>'
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return `
                    <a class="btn btn-primary" href="?page=edit-event&id=${row.id}">
                        <i class="fa-solid fa-pen"></i>
                    </a>
                    ${row.status
                            ? `<button class="btn btn-success" onclick="activateEvent(${row.id},0)">
                        <i class="fa-solid fa-check"></i>
                       </button>`
                            : ` <button class="btn btn-danger" onclick="activateEvent(${row.id},1)">
                         <i class="fa-solid fa-x"></i>
                        </button>`}
                    `
                }
            }
        ],
        language: {
            url: 'public/assets/datatables/es-Es.json',
        },
    })


})
function activateEvent(id, status) {
    Swal.fire({
        title: `${status ? 'Activar' : 'Desactivar'} Evento`,
        text: `¿Estás seguro de ${status ? 'Activar' : 'Desactivar'} este evento?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: `${status ? '#198754' : '#dc3545'}`,
        cancelButtonColor: "#808080",
        confirmButtonText: `${status ? 'Activar' : 'Desactivar'}`
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/events_en/status', id: id, status: status },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Estado actualizado',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#eventsTable').DataTable().ajax.reload();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                },
                error: (xhr, status, error) => {
                    console.log('Error: ', error, xhr, status)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        }
    });
}