$(function () {
    let coverImageIndex = 0;
    
    FilePond.registerPlugin(FilePondPluginImagePreview,
        FilePondPluginImageResize,
        FilePondPluginImageCrop,
        FilePondPluginFileValidateSize,
        FilePondPluginFileValidateType,
        FilePondPluginFileValidateSize
    );

    const pond = FilePond.create(document.getElementById('images'), {
        instantUpload: false,
        allowProcess: false,
        allowRevert: false,
        labelIdle: 'Arrastra tus imagenes aquí o <span class="filepond--label-action">Selecciona</span>',
        labelInvalidField: 'Campo inválido',
        labelFileLoading: 'Cargando',
        labelFileLoadError: 'Error al cargar',
        labelFileProcessing: 'Procesando',
        labelFileProcessingComplete: 'Procesado',
        labelFileProcessingAborted: 'Procesamiento cancelado',
        labelFileProcessingError: 'Error al procesar',
        labelFileProcessingRevertError: 'Error al revertir',
        labelFileRemoveError: 'Error al eliminar',
        labelTapToCancel: 'Toca para cancelar',
        labelTapToRetry: 'Toca para reintentar',
        labelTapToUndo: 'Toca para deshacer',
        labelButtonRemoveItem: 'Eliminar',
        labelButtonAbortItemLoad: 'Abortar',
        labelButtonAbortItemProcessing: 'Cancelar',
        labelButtonUndoItemProcessing: 'Deshacer',
        labelButtonRetryItemProcessing: 'Reintentar',
        labelButtonProcessItem: 'Subir',
        labelMaxFileSizeExceeded: 'El archivo es demasiado grande',
        labelMaxFileSize: 'El tamaño máximo del archivo es {filesize}',
        maxFiles: 10,
        allowMultiple: true,
        acceptedFileTypes: ['image/*'],
        maxFileSize: '1MB',
        imagePreviewHeight: 200,
        imageCropAspectRatio: '16:9',
        imageResizeTargetWidth: 800,
        imageResizeTargetHeight: 450,
        styleItemPanelAspectRatio: 0.5,
        styleLoadIndicatorPosition: 'center bottom',
        styleProgressIndicatorPosition: 'right bottom',
        styleButtonRemoveItemPosition: 'left bottom',
        styleButtonProcessItemPosition: 'right bottom',
        server: {
            url: './routes/upload.php',
            method: 'POST',
            withCredentials: false,
            headers: {},
            timeout: 7000
        }
    });

    pond.on('addfile', (error, file) => {
        if (!error) {
            setTimeout(() => {
                updateRadioButtons();
            }, 100);
        }
    });

    pond.on('removefile', (error, file) => {
        if (!error) {
            setTimeout(() => {
                updateRadioButtons();
            }, 100);
        }
    });

    function updateRadioButtons() {
        const files = pond.getFiles();
        const items = pond.element.querySelectorAll('.filepond--item');
        
        items.forEach(item => {
            const existingRadio = item.querySelector('.cover-radio');
            if (existingRadio) {
                existingRadio.remove();
            }
        });
        
        if (files.length > 0) {
            items.forEach((item, index) => {
                const radioId = `cover-${index}`;
                const radioHtml = `
                    <div class="cover-radio">
                        <input type="radio" name="coverImage" id="${radioId}" value="${index}" ${index === 0 ? 'checked' : ''}>
                        <label for="${radioId}">Portada</label>
                    </div>
                `;
                item.insertAdjacentHTML('beforeend', radioHtml);
                
                const radio = item.querySelector(`#${radioId}`);
                radio.addEventListener('change', function() {
                    coverImageIndex = parseInt(this.value);
                });
            });
        }
    }

    const showError = (input, message) => {
        $(input).after(`<span class="text-danger">${message}</span>`)
    }

    const clearError = (input) => {
        $(input).next('.text-danger').remove()
    }

    $('#form').on('submit', (e) => {
        e.preventDefault()
        let hasErrors = false

        const name = $('#name').val()
        const place = $('#place').val()
        const date = $('#date').val()

        clearError('#name')
        clearError('#place')
        clearError('#date')
        clearError('#images')

        if (!name) {
            showError('#name', 'El nombre es requerido')
            hasErrors = true
        } else if (name.lenght > 255) {
            showError('#name', 'El nombre no puede ser mayor a 255 caracteres')
            hasErrors = true
        }

        if (!place) {
            showError('#place', 'El lugar es requerido')
            hasErrors = true
        } else if (place.length > 255) {
            showError('#place', 'El lugar no puede ser mayor a 255 caracteres')
            hasErrors = true
        }

        if (!date) {
            showError('#date', 'La fecha es requerida')
            hasErrors = true
        }

        if (pond.getFiles().length === 0) {
            showError('#images', 'Se requieren imagenes');
            hasErrors = true;
        }

        if (hasErrors) return

        pond.processFiles().then(files => {
            const allFiles = pond.getFiles();
            const images = allFiles.map((f, index) => ({
                name: f.serverId || f.source,
                isCover: index === coverImageIndex ? 1 : 0
            }));

            const formData = {
                name: name,
                place: place,
                date: date,
                images: images
            }

            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/galleries_en/store', data: formData, },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Exito!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            window.location.href = '?page=galleries'
                        });
                    }
                },
                error: (error) => {
                    console.log('Error: ', error)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'Hubo un error al procesar la solicitud'
                    });
                }
            })
        })        
    })
})