$(() => {
    $('#blogsTable').DataTable({
        processing: true,
        ordering: false,
        ajax: {
            url: './routes/web.php',
            type: 'GET',
            data: function (d) {
                d.REQUEST_URI = '/blogs_en/list'
            },
            dataSrc: 'blogs'
        },
        columns: [
            { data: 'id' },
            { data: 'img' ,
                render: function (data, type, row, meta) {
                    return `<div style="width: 100px; height: 100px; display: flex; align-items: center; justify-content: center; overflow: hidden; border-radius: 12px; background: #f3f3f3;">
                        <img src="./resources/images/blogs/${data}" alt="Imagen" style="width: 100%; height: 100%; object-fit: cover; object-position: center; display: block;">
                    </div>`
                } 
            },
            { data: 'title',
                render: function(data, type, row, meta){
                    return row.title.length > 20 ? row.title.substring(0,20) + '...': row.title
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return row.status ? `<span class="badge text-bg-success">Activo</span>` : '<span class="badge text-bg-danger">Inactivo</span>'
                }
            },
            {
                data: null,
                render: function (data, type, row, meta) {
                    return `
                    <a class="btn btn-primary" href="?page=edit-blog&id=${row.id}">
                        <i class="fa-solid fa-pen"></i>
                    </a>
                    ${row.status
                            ? `<button class="btn btn-success" onclick="activateBlog(${row.id},0)">
                        <i class="fa-solid fa-check"></i>
                       </button>`
                            : ` <button class="btn btn-danger" onclick="activateBlog(${row.id},1)">
                         <i class="fa-solid fa-x"></i>
                        </button>`}
                    `
                }
            }
        ],
        language: {
            url: 'public/assets/datatables/es-Es.json',
        },
    })


})
function activateBlog(id, status) {
    Swal.fire({
        title: `${status ? 'Activar' : 'Desactivar'} Blog`,
        text: `¿Estás seguro de ${status ? 'Activar' : 'Desactivar'} este blog?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: `${status ? '#198754' : '#dc3545'}`,
        cancelButtonColor: "#808080",
        confirmButtonText: `${status ? 'Activar' : 'Desactivar'}`
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: './routes/web.php',
                type: 'POST',
                data: { REQUEST_URI: '/blogs_en/status', id: id, status: status },
                success: (response) => {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'STATUS UPDATED',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#blogsTable').DataTable().ajax.reload();
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                },
                error: (xhr, status, error) => {
                    console.log('Error: ', error, xhr, status)
                    Swal.fire({
                        icon: 'error',
                        title: '¡Error!',
                        text: 'AN ERROR OCCURRED WHILE PROCESSING YOUR REQUEST',
                    });
                }
            })
        }
    });
}