<?php
require_once __DIR__ . '/../models/User.php';
header('Content-Type: application/json');
class UserController
{
    public static function index()
    {
        $users = User::all();
        echo json_encode([
            'success' => true,
            'message' => 'Users retrieved successfully',
            'users' => $users
        ]);
    }
    public static function show($id)
    {
        $user = User::findById($id);
        echo json_encode([
            'success' => true,
            'message' => 'User found successfully!',
            'user' => $user
        ]);
    }
    public static function store($name, $username, $email, $password, $role)
    {
        if (User::create($name, $username, $email, $password, $role)) {
            echo json_encode([
                'success' => true,
                'message' => 'User created successfully!',
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Error creating user'
            ]);
        }
    }
    public static function update($id, $name, $username, $email, $role, $status, $password = null)
    {
        $data = [];
        if ($password) {
            $data = [
                'name' => $name,
                'username' => $username,
                'email' => $email,
                'password' => $password,
                'role' => $role,
                'status' => $status
            ];
        } else {
            $data = [
                'name' => $name,
                'username' => $username,
                'email' => $email,
                'role' => $role,
                'status' => $status
            ];
        }

        if (User::update($id, $data)) {
            echo json_encode([
                'success' => true,
                'message' => 'User updated successfully!',
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Error updating user'
            ]);
        }
    }
    public static function status(int $id, $status)
    {
        $success = false;
        $message = '';
        if (User::update($id, ['status' => $status])) {
            $success = true;
            $message = 'User updated successfully!';
            $user = User::findById($id);

            if (session_status() === PHP_SESSION_NONE) {
                session_start();
            }
            if (isset($_SESSION['user']) && $_SESSION['user']['id'] == $id) {
                if ($user) {
                    $_SESSION['user'] = $user;
                    if ($status == 0) {
                        session_destroy();
                    }
                }
            }
        } else {
            $message = 'Error updating user';
        }
        echo json_encode([
            'success' => $success,
            'message' => $message
        ]);
    }
    public static function checkEmail($email, $excludeId = null)
    {
        $user = User::findByEmail($email, $excludeId);
        if ($user) {
            echo json_encode([
                'success' => true,
                'message' => 'This email is already in use',
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'This Email is not in use'
            ]);
        }
    }
    public static function checkUsername($username, $excludeId = null)
    {
        $user = User::findByUsername($username, $excludeId);
        if ($user) {
            echo json_encode([
                'success' => true,
                'message' => 'This username is already in use',
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'This username is not in use'
            ]);
        }
    }
}
