<?php
require_once __DIR__ . '/../models/Event.php';
header('Content-Type: application/json');   
class EventController
{
    public static function index($status){
        $events = Event::all($status);
        echo json_encode([
            'success' => true,
            'message' => 'Events retrieved successfully!',
            'events' => $events
        ]);
    }
    public static function store($name,$place,$date,$banner){
        if(Event::create($name,$place,$date,$banner)){
            echo json_encode([
                'success' => true,
                'message' => 'Event created successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error creating event!'
            ]);
        }
    }
    public static function show($id){
        $event = Event::findById($id);
        echo json_encode([
            'success' => true,
            'message' => 'Event found successfully!',
            'event' => $event
        ]);
    }
    public static function update(int $id, $name, $place, $date, $banner, $status)
    {
        $event = Event::findById($id);
        $banner_old = $event['banner'];
        if($banner_old != $banner){
            self::deleteBanner($banner_old);
        }
        if(Event::update($id,['name'=>$name, 'place'=>$place, 'date'=>$date, 'banner'=>$banner, 'status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => 'Event updated successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error updating event!'
            ]);
        }
    }
    public static function status(int $id, $status)
    {
        if(Event::update($id,['status'=>$status])){
            echo json_encode([
                'success' => true,
                'message' => 'Event updated successfully!',
            ]);
        }else{
            echo json_encode([
                'success' => false,
                'message' => 'Error updating event!'
            ]);
        }
    }
    public static function uploadBanner($file){
        $uploadDir  = __DIR__ . '/../../resources/images/events/';
        if(!is_dir($uploadDir)){
            mkdir($uploadDir, 0777, true);
        }
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $safeName = uniqid('banner_',true).'.'.$ext;
        $uploadFile = $uploadDir . $safeName;
        if(move_uploaded_file($file['tmp_name'], $uploadFile)){
            echo $safeName;
        }
    }
    public static function deleteBanner($filename){
        $uploadDir  = __DIR__ . '/../../resources/images/events/';
        $file = $uploadDir . $filename;
        if(file_exists($file)){
            unlink($file);
        }
    }
}