/* class TranslateManager {
    constructor() {
        // Detectar idioma desde el <html lang="">
        this.currentLanguage = document.documentElement.lang || 'es';
        this.translations = {};
        this.init();
        }

    async init() {
        await this.loadTranslations();
        this.applyLanguage(this.currentLanguage);
    }

    async loadTranslations() {
        try {
            const timestamp = new Date().getTime();
            let langFile = '';

            if (this.currentLanguage === 'en') {
                langFile = './resources/lang/en-EN.json';
            } else {
                langFile = './resources/lang/es-ES.json';
            }

            const response = await fetch(`${langFile}?v=${timestamp}`);
            if (!response.ok) {
                console.error(`Error loading ${langFile}`);
                return;
            }

            this.translations[this.currentLanguage] = await response.json();

        } catch (error) {
            console.error('Error loading translations:', error);
        }
    }

    applyLanguage(lang) {
        const translations = this.translations[lang];
        if (!translations) {
            console.error('No translations found for language:', lang);
            return;
        }

        const elementsToTranslate = document.querySelectorAll('[data-translate]');
        elementsToTranslate.forEach(element => {
            const key = element.getAttribute('data-translate');
            const translation = this.getNestedTranslation(translations, key);

            if (translation) {
                if (element.tagName === 'INPUT' && 
                (element.type === 'text' || element.type === 'email' || element.type === 'tel')) {
                    element.placeholder = translation;
                } else if (element.tagName === 'BUTTON' || element.tagName === 'A') {
                    element.textContent = translation;
                } else {
                    element.innerHTML = translation;
                }
            }
        });
    }

    getNestedTranslation(obj, path) {
        return path.split('.').reduce((current, key) => {
            return current && current[key] !== undefined ? current[key] : null;
        }, obj);
    }
}

document.addEventListener('DOMContentLoaded', () => {
    window.translateManager = new TranslateManager();
});
 */