<?php
// Detectar idioma según la URL o carpeta actual
$currentPath = $_SERVER['REQUEST_URI'];
$isEnglish = (strpos($currentPath, '/en/') !== false);

// Usar la infraestructura de base de datos existente
require_once __DIR__ . '/../../../../sistema/sistema_es/infrastructure/Database.php';

$currentBlog = null;
$moreBlogs = [];

// Obtener el ID del blog de la URL
$blogId = $_GET['id'] ?? null;

if ($blogId) {
    try {
        $conn = Database::getConnection();
        
        // Seleccionar la tabla correcta según el idioma
        $tableBlog = $isEnglish ? 'blogs_en' : 'blogs';
        
        // Obtener el blog específico
        $sqlCurrent = "SELECT * FROM $tableBlog WHERE id = :id AND status = 1";
        $stmtCurrent = $conn->prepare($sqlCurrent);
        $stmtCurrent->bindParam(':id', $blogId, PDO::PARAM_INT);
        $stmtCurrent->execute();
        $currentBlog = $stmtCurrent->fetch();
        
        // Obtener más blogs (excluyendo el actual)
        $sqlMore = "SELECT * FROM $tableBlog WHERE id != :id AND status = 1 ORDER BY id DESC LIMIT 3";
        $stmtMore = $conn->prepare($sqlMore);
        $stmtMore->bindParam(':id', $blogId, PDO::PARAM_INT);
        $stmtMore->execute();
        $moreBlogs = $stmtMore->fetchAll();
        
    } catch(PDOException $e) {
        error_log("Error en detailBlog: " . $e->getMessage());
        // No mostrar el error al usuario, solo manejar graciosamente
    }
}

// Definir la ruta del sistema según el idioma
$sistemaPath = $isEnglish ? '../sistema/sistema_en' : '../sistema/sistema_es';
?>

<link rel="stylesheet" href="./views/pages/detailBlog/detailBlog.css">

<div class="container-fluid section-specific" <?php if ($currentBlog && !empty($currentBlog['img'])): ?>style="background-image: url('<?php echo $sistemaPath; ?>/resources/images/blogs/<?php echo htmlspecialchars($currentBlog['img']); ?>');"<?php endif; ?>>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <span class="text-white titulo" style="font-size: 4rem;">BLOG</span>
            </div>
        </div>
    </div>
</div>
<div class="container blog-container">
    <div class="row">
        <div class="col-12 col-lg-8 mx-auto" style="padding-top: 150px; padding-bottom: 150px;">
            <h1 class="fw-bold mb-3" style="font-size: 2rem;" id="title">
                <?php if ($currentBlog): ?>
                    <?php echo htmlspecialchars($currentBlog['title']); ?>
                <?php else: ?>
                    Blog no encontrado
                <?php endif; ?>
            </h1>
            <article class="m-0" id="description">
                <?php if ($currentBlog): ?>
                    <?php echo $currentBlog['description']; ?>
                <?php else: ?>
                    El blog que buscas no existe o no está disponible.
                <?php endif; ?>
            </article>
        </div>
        <div class="col-12 my-0">
            <h3>Más Blogs</h3>
        </div>
    <div class="col-12">
    <div class="row g-4 more-blogs" id="blogs">
            <?php if (!empty($moreBlogs)): ?>
                <?php foreach ($moreBlogs as $blog): ?>
                    <div class="col-12 col-md-6 col-lg-4">
                        <div class="card h-100 border-0 shadow-sm">
                            <?php if (!empty($blog['img'])): ?>
                                <img src="<?php echo $sistemaPath; ?>/resources/images/blogs/<?php echo htmlspecialchars($blog['img']); ?>" class="rounded-4 w-100 mb-2" alt="<?php echo htmlspecialchars($blog['title']); ?>" style="aspect-ratio:16/9; object-fit:cover;">
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title my-2"><?php echo htmlspecialchars($blog['title']); ?></h5>
                                <p class="card-text flex-grow-1"><?php echo substr(strip_tags($blog['description'] ?? ''), 0, 150) . '...'; ?></p>
                                <a href="?page=detailBlog&id=<?php echo $blog['id']; ?>" class="btn btn-outline-primary rounded-pill px-4 mt-auto">Ver más</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <p class="text-center">No hay más blogs disponibles.</p>
                </div>
            <?php endif; ?>
        </div>
        </div>
    </div>
</div>
<div class="container">
    <div class="d-flex justify-content-center py-5 my-5">
        <a href="?page=blog" class="btn rounded-4 text-white fw-bold btn-lg px-5" style="background-color: #19b0df;">
            Ir al Blog
        </a>
    </div>
</div>