$(()=>{
    document.querySelectorAll('a[href^="#"], a[href^="?page=home#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            let href = this.getAttribute('href');
            let hash = '';
            if (href.startsWith('?page=home#')) {
                hash = href.split('#')[1];
                if (window.location.search.indexOf('page=home') === -1 && window.location.pathname !== '/' && window.location.pathname !== '/index.php') {
                    localStorage.setItem('scrollToHash', hash);
                    return;
                }
            } else if (href.startsWith('#')) {
                hash = href.substring(1);
            }
            if (hash) {
                const target = document.getElementById(hash);
                if (target) {
                    e.preventDefault();
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    const offcanvas = document.querySelector('.offcanvas.show');
                    if (offcanvas) {
                        const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvas);
                        if (bsOffcanvas) bsOffcanvas.hide();
                    }
                }
            }
        });
    });

    const hashToScroll = localStorage.getItem('scrollToHash');
    if (hashToScroll) {
        const target = document.getElementById(hashToScroll);
        if (target) {
            setTimeout(() => {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }, 300);
        }
        localStorage.removeItem('scrollToHash');
    }

    // Detectar el idioma actual basado en la URL
    const currentPath = window.location.pathname;
    const isSpanish = currentPath.includes('/es/');
    const sistemaPath = isSpanish ? '../sistema/sistema_es' : '../sistema/sistema_en';
    const blogEndpoint = isSpanish ? '/blogs' : '/blogs_en';
    
    let params = new URLSearchParams(location.search);
    const id = params.get('id');
    
    // Verificar si PHP cargó el contenido o si necesitamos AJAX como respaldo
    const titleElement = document.getElementById('title');
    const descriptionElement = document.getElementById('description');
    const needsAjaxLoad = !titleElement || titleElement.textContent.trim() === '' || titleElement.textContent === 'Blog no encontrado';
    
    if (id && /^[1-9][0-9]*$/.test(id)) {
        $.ajax({
            url: `${sistemaPath}/routes/web.php`,
            type: 'POST',
            data: {REQUEST_URI: `${blogEndpoint}/find-by-id/post`, id: id},
            success: (response) => {
                const blog = response.blog;
                const section_specific = document.querySelector('.section-specific');
                
                if (blog) {
                    // Establecer imagen de fondo
                    if (blog.img && section_specific) {
                        section_specific.style.backgroundImage = `url('${sistemaPath}/resources/images/blogs/${blog.img}')`;
                    }
                    
                    // Si PHP no cargó el contenido, cargarlo con AJAX
                    if (needsAjaxLoad && titleElement && descriptionElement) {
                        titleElement.textContent = blog.title; // Solo título como texto
                        descriptionElement.innerHTML = blog.description; // HTML completo sin escapar
                    }
                }
            },
            error: function() {
                console.log('Error al cargar el blog');
            }
        });
        
        // Cargar blogs relacionados si el contenedor está vacío
        const blogsContainer = document.getElementById('blogs');
        if (blogsContainer && blogsContainer.children.length === 0) {
            $.ajax({
                url: `${sistemaPath}/routes/web.php`,
                type: 'POST',
                data: {REQUEST_URI: `${blogEndpoint}/list/active`},
                success: (response) => {
                    const blogs = response.blogs;
                    
                    if (!blogs || blogs.length === 0) {
                        blogsContainer.innerHTML = `
                            <div class="col-12 text-center py-5">
                                <i class="fa-regular fa-newspaper fa-2x mb-2 text-info"></i>
                                <div class="text-muted">${isSpanish ? 'Próximamente artículos disponibles' : 'Articles coming soon'}</div>
                            </div>
                        `;
                        return;
                    }
                    
                    // Filtrar blogs (excluir el actual) y mezclar
                    const filteredBlogs = blogs.filter(b => b.id != id);
                    filteredBlogs.sort(() => Math.random() - 0.5);
                    
                    // Mostrar máximo 3 blogs
                    const blogsToShow = filteredBlogs.slice(0, 3);
                    
                    blogsContainer.innerHTML = '';
                    blogsToShow.forEach((b) => {
                        blogsContainer.innerHTML += `
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card h-100 border-0 shadow-sm">
                                    <img src="${sistemaPath}/resources/images/blogs/${b.img}" class="card-img-top" alt="${b.title}" style="height: 200px; object-fit: cover;">
                                    <div class="card-body d-flex flex-column">
                                        <h5 class="card-title">${b.title}</h5>
                                        <p class="card-text flex-grow-1">${b.description.replace(/<[^>]*>/g, '').substring(0, 150)}...</p>
                                        <a href="?page=detailBlog&id=${b.id}" class="btn btn-primary mt-auto">${isSpanish ? 'Leer más' : 'Read more'}</a>
                                    </div>
                                </div>
                            </div>
                        `;
                    });
                },
                error: function() {
                    console.log('Error al cargar blogs relacionados');
                }
            });
        }
    }
});

document.addEventListener('hidden.bs.offcanvas', function (event) {
    if (window.location.pathname === '/' || window.location.pathname.endsWith('index.php')) {
        const togglerIcon = document.querySelector('.navbar-toggler-icon');
        if (togglerIcon) {
            togglerIcon.style.backgroundImage = "url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e\")";
        }
    }
});

document.addEventListener('hidden.bs.offcanvas', function (event) {
    if (window.location.pathname === '/' || window.location.pathname.endsWith('index.php')) {
        const togglerIcon = document.querySelector('.navbar-toggler-icon');
        if (togglerIcon) {
            togglerIcon.style.backgroundImage = "url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%2833, 37, 41, 0.75%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e\")";
        }
    }
});
            const randomBlogs = blogs.slice(0,4)
            divBlogs.innerHTML = ''
            randomBlogs.forEach(b => {
                divBlogs.innerHTML += `
                <div class="col-12 col-md-3">
                    <div>
                        <img src="${sistemaPath}/resources/images/blogs/${b.img}" class="rounded-4 w-100 mb-2" style="aspect-ratio: 16/9; object-fit: cover;" alt="${b.title}">
                        <div class="d-flex flex-column justify-content-between">
                        <span class="fw-bold title blog-title-ellipsis my-2" style="font-size: 1.3rem;">${b.title}</span>
                        <a href="?page=detailBlog&id=${b.id}" class="btn btn-light rounded-pill px-4 mb-2">${isSpanish ? 'Ver más' : 'Read more'}</a>
                    </div>
                </div>`
            });

document.addEventListener('hidden.bs.offcanvas', function (event) {
    if (window.location.pathname === '/' || window.location.pathname.endsWith('index.php')) {
        if (window.location.hash) {
            history.replaceState(null, null, window.location.pathname + window.location.search);
        }
    }
});

document.getElementById('customMenuBtn').addEventListener('click', function() {
    document.getElementById('customOffcanvas').classList.add('open');
    document.getElementById('customOffcanvasBackdrop').classList.add('open');
    document.body.style.overflow = 'hidden';
});
document.getElementById('customCloseBtn').addEventListener('click', closeCustomOffcanvas);
document.getElementById('customOffcanvasBackdrop').addEventListener('click', closeCustomOffcanvas);
function closeCustomOffcanvas() {
    document.getElementById('customOffcanvas').classList.remove('open');
    document.getElementById('customOffcanvasBackdrop').classList.remove('open');
    document.body.style.overflow = '';
}
document.querySelectorAll('#customOffcanvas .nav-link').forEach(link => {
    link.addEventListener('click', closeCustomOffcanvas);
});

$('#enviar').on('click', function(e) {
    e.preventDefault();
    const emailInput = $('#form [name="email"]');
    const email = emailInput.val().trim();
    const alerta = $('#alerta-suscripcion');
    
    const currentPath = window.location.pathname;
    const isSpanish = currentPath.includes('/es/');
    const sistemaPath = isSpanish ? '../sistema/sistema_es' : '../sistema/sistema_en';

    const emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
    const accentRegex = /[áéíóúÁÉÍÓÚñÑüÜ]/;

    if (!email) {
        alerta.html(`
            <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                 style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                <strong>⚠️ Atención:</strong> Por favor ingresa tu correo electrónico.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
            </div>
        `);
        return;
    }

    if (!emailRegex.test(email)) {
        alerta.html(`
            <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                 style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                <strong>📧 Correo no válido:</strong> Asegúrate de ingresar un correo electrónico correcto.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
            </div>
        `);
        return;
    }

    if (accentRegex.test(email)) {
        alerta.html(`
            <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert"
                 style="border-left: 5px solid #ffc107; box-shadow: 0 4px 12px rgba(255, 193, 7, 0.2); font-size: 1rem;">
                <strong>❌ Sin acentos:</strong> El correo no debe contener acentos ni caracteres especiales como "ñ".
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
            </div>
        `);
        return;
    }

    $.post(`${sistemaPath}/routes/web.php`, {
            REQUEST_URI: '/mail/send',
            email
        })
        .done(function(response) {
            emailInput.val('');
            alerta.html(`
                <div class="alert alert-success alert-dismissible fade show mt-3" role="alert"
                     style="border-left: 5px solid #198754; box-shadow: 0 4px 12px rgba(25, 135, 84, 0.2); font-size: 1rem;">
                    <strong>✅ ¡Gracias!</strong> Te has suscrito correctamente.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                </div>
            `);
        })
        .fail(function() {
            alerta.html(`
                <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert"
                     style="border-left: 5px solid #dc3545; box-shadow: 0 4px 12px rgba(220, 53, 69, 0.2); font-size: 1rem;">
                    <strong>⚠️ Error:</strong> No se pudo completar la suscripción. Intenta más tarde.
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
                </div>
            `);
        });
});