<?php
require_once __DIR__ . '/../app/controllers/AuthController.php';
require_once __DIR__ . '/../app/controllers/EventController.php';
require_once __DIR__ . '/../app/controllers/UserController.php';
require_once __DIR__ . '/../app/controllers/BlogController.php';
require_once __DIR__ . '/../app/controllers/VideoController.php';
require_once __DIR__ . '/../app/controllers/GalleryController.php';
require_once __DIR__ . '/../app/controllers/MailController.php';
header('Content-Type: application/json');

$routes = [
    '/auth/login'        => function () {
        AuthController::login($_POST['data']['email'], $_POST['data']['password']);
    },
    '/auth/logout'       => function () {
        AuthController::logout();
    },
    '/galleries/recent' => function () {
        GalleryController::recent();
    },
    '/galleries/list'    => function () {
        GalleryController::index();
    },
    '/galleries/store'   => function () {
        GalleryController::store($_POST['data']['name'], $_POST['data']['place'], $_POST['data']['date'], $_POST['data']['images']);
    },
    '/galleries/status'  => function () {
        GalleryController::status($_POST['id'], $_POST['status']);
    },
    '/galleries/update'  => function () {
        GalleryController::update($_POST['data']['id'], $_POST['data']['name'], $_POST['data']['place'], $_POST['data']['date'], $_POST['data']['images'], $_POST['data']['status']);
    },
    '/galleries/find-by-id' => function () {
        GalleryController::show($_GET['id']);
    },
    '/galleries/find-by-id/post' => function () {
        GalleryController::show($_POST['id']);
    },
    '/events/list'       => function () {
        EventController::index(false);
    },
    '/events/list/active' => function () {
        EventController::index(true);
    },
    '/events/status'     => function () {
        EventController::status($_POST['id'], $_POST['status']);
    },
    '/events/store'      => function () {
        EventController::store($_POST['data']['name'], $_POST['data']['place'], $_POST['data']['date'], $_POST['data']['banner']);
    },
    '/events/update'     => function () {
        EventController::update($_POST['data']['id'], $_POST['data']['name'], $_POST['data']['place'], $_POST['data']['date'], $_POST['data']['banner'], $_POST['data']['status']);
    },
    '/events/find-by-id' => function () {
        EventController::show($_GET['id']);
    },
    '/users/list'        => function () {
        UserController::index();
    },
    '/users/store'       => function () {
        UserController::store($_POST['data']['name'], $_POST['data']['username'], $_POST['data']['email'], $_POST['data']['password'], $_POST['data']['role']);
    },
    '/users/update'      => function () {
        UserController::update($_POST['data']['id'], $_POST['data']['name'], $_POST['data']['username'], $_POST['data']['email'], $_POST['data']['role'], $_POST['data']['status'], $_POST['data']['password'] ?? null);
    },
    '/users/status'      => function () {
        UserController::status($_POST['id'], $_POST['status']);
    },
    '/users/check-email' => function () {
        UserController::checkEmail($_POST['email'], $_POST['excludeId']);
    },
    '/users/check-username' => function () {
        UserController::checkUsername($_POST['username'], $_POST['excludeId']);
    },
    '/users/find-by-id'  => function () {
        UserController::show($_GET['id']);
    },
    '/blogs/list'        => function () {
        BlogController::index(false);
    },
    '/blogs/list/active' => function () {
        BlogController::index(true);
    },
    '/blogs/store'       => function () {
        BlogController::store($_POST['data']['title'], $_POST['data']['description'], $_POST['data']['img']);
    },
    '/blogs/status'      => function () {
        BlogController::status($_POST['id'], $_POST['status']);
    },
    '/blogs/update'      => function () {
        BlogController::update($_POST['data']['id'], $_POST['data']['title'], $_POST['data']['description'], $_POST['data']['img'], $_POST['data']['status']);
    },
    '/blogs/find-by-id'  => function () {
        BlogController::show($_GET['id']);
    },
    '/blogs/find-by-id/post'  => function () {
        BlogController::show($_POST['id']);
    },
    '/videos/list'       => function () {
        VideoController::index(false);
    },
    '/videos/list/active' => function () {
        VideoController::index(true);
    },
    '/videos/store'      => function () {
        VideoController::store($_POST['data']['link']);
    },
    '/videos/status'     => function () {
        VideoController::status($_POST['id'], $_POST['status']);
    },
    '/videos/find-by-id' => function () {
        VideoController::show($_GET['id']);
    },
    '/videos/update'     => function () {
        VideoController::update($_POST['data']['id'], $_POST['data']['link'], $_POST['data']['status']);
    },
    '/mail/send' => function () {
        MailController::send($_POST['name'], $_POST['email'], $_POST['phone']);
    }
];

$request_uri = isset($_GET['REQUEST_URI']) ? $_GET['REQUEST_URI'] : (isset($_POST['REQUEST_URI']) ? $_POST['REQUEST_URI'] : '/');

if (isset($routes[$request_uri])) {
    $routes[$request_uri]();
} else {
    echo json_encode([
        'success' => false,
        'message' => '¡Ruta invalida!'
    ]);
}
