$(() => {
    const showError = (input, message) => {
        $(input).after(`<span class="text-danger ms-2">${message}</span>`)
    }

    const clearError = (input) => {
        $(input).next('.text-danger').remove()
    }

    $('#form').on('submit', async (e) => {
        e.preventDefault();
        let hasErrors = false


        const formData = {
            name: $('#name').val(),
            username: $('#username').val(),
            email: $('#email').val(),
            password: $('#password').val(),
            password_confirmation: $('#password_confirmation').val(),
            role: $('#role').val(),
            status: $('#status').val()
        }

        clearError('#name')
        clearError('#username')
        clearError('#email')
        clearError('#password')
        clearError('#password_confirmation')
        clearError('#role')
        clearError('#status')

        if (!formData.name) {
            showError('#name', 'El nombre es requerido')
            hasErrors = true
        } else if (formData.name.length > 255) {
            showError('#name', 'El nombre no puede tener más de 255 caracteres')
            hasErrors = true
        }

        if (!formData.username) {
            showError('#username', 'El nombre de usuario es requerido')
            hasErrors = true
        } else if (formData.username.length > 255) {
            showError('#username', 'El nombre de usuario no puede tener más de 255 caracteres')
            hasErrors = true
        }

        if (!formData.email) {
            showError('#email', 'El correo electrónico es requerido')
            hasErrors = true
        }

        if (!formData.password) {
            showError('#password', 'La contraseña es requerida')
            hasErrors = true
        }
        if (formData.password !== formData.password_confirmation) {
            showError('#password_confirmation', 'Las contraseñas no coinciden')
            hasErrors = true
        }

        if (!formData.role) {
            showError('#role', 'El rol es requerido')
            hasErrors = true
        }

        const checkDuplicate = (type, value) => {
            return new Promise((resolve) => {
                $.ajax({
                    url: './routes/web.php',
                    type: 'POST',
                    data: {
                        REQUEST_URI: `/users/check-${type}`,
                        [type]: value,
                        excludeId: null
                    },
                    success: (response) => {
                        if (response.success) {
                            showError(`#${type}`, response.message);
                            resolve(true);
                        } else {
                            resolve(false);
                        }
                    },
                    error: (error) => {
                        console.log('Error: ', error);
                        resolve(true);
                    }
                });
            })
        }

        const [emailDuplicado, usernameDuplicado] = await Promise.all([
            checkDuplicate('email', formData.email),
            checkDuplicate('username', formData.username)
        ]);

        if (hasErrors || emailDuplicado || usernameDuplicado) return;

        $.ajax({
            url: './routes/web.php',
            type: 'POST',
            data: { REQUEST_URI: '/users/store', data: formData, },
            success: (response) => {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: '¡Exito!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        window.location.href = '?page=users'
                    });
                }
            },
            error: (error) => {
                console.log('Error: ', error)
                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    text: 'Hubo un error al procesar la solicitud'
                });
            }
        })
    })
})